/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitPreferences.java,v 1.6 2008/01/22 13:16:07 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.common.TestCommon;

/**
 * JUnit core preferences constants.
 * 
 * 
 * @author  Julien Canches
 * @author  Paul E. Slauenwhite
 * @version January 28, 2008
 * @since   Sepember 1, 2006
 */
public class JUnitPreferences extends AbstractPreferenceInitializer {

	public static final String DEFAULT_JUNIT_TEST_SUITE_FACTORY = "defaultJUnitTestSuiteFactory"; //$NON-NLS-1$
	public static final String DEFAULT_DEFAULT_JUNIT_TEST_SUITE_FACTORY = TestCommon.JUNIT_TEST_SUITE_TYPE;
	
	public static final String DEFAULT_JUNIT_TEST_SUITE_PATH = "defaultJUnitTestSuitePath"; //$NON-NLS-1$

	public static final String DEFAULT_DEFAULT_COMMON_JUNIT_TEST_SUITE_PATH = "/${tptp_junit_project}/junit/${tptp_junit_type_name}.testsuite"; //$NON-NLS-1$

	public static final String DEFAULT_DEFAULT_JUNIT_TEST_SUITE_PATH = "${tptp_junit_container_path}/${tptp_junit_type_name}.testsuite"; //$NON-NLS-1$

	public void initializeDefaultPreferences() {
		Preferences prefs = CorePlugin.getInstance().getPluginPreferences();
		prefs.setDefault(DEFAULT_JUNIT_TEST_SUITE_FACTORY, DEFAULT_DEFAULT_JUNIT_TEST_SUITE_FACTORY);
		prefs.setDefault(DEFAULT_JUNIT_TEST_SUITE_PATH, DEFAULT_DEFAULT_JUNIT_TEST_SUITE_PATH);
	}
	
}
