/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestSuiteFactoryOptions.java,v 1.4 2007/05/02 19:36:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.java.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;

/**
 * Utility class for computing options related to junit import to TPTP.
 * @author jcanches
 * @since 4.3
 */
public class JUnitTestSuiteFactoryOptions {

	/**
	 * Returns the JUnit preference for a given resource. This implementation looks up
	 * the resource's project preferences first, then defaults to the workspace preferences,
	 * then defaults to the default preference.
	 * @param prefName The preference name 
	 * @return The value of the preference as a string.
	 */
	private static String getJUnitPreference(String prefName, IResource res) {
		IProject project = res.getProject();
		IEclipsePreferences node = new ProjectScope(project).getNode(CorePlugin.PLUGIN_ID);
		String type = node.get(prefName, null);
		if (type != null) return type;
		Preferences prefs = CorePlugin.getInstance().getPluginPreferences();
		return prefs.getString(prefName);
	}
	
	public static String getDefaultJUnitTestSuiteType(IJavaProject project) {
		return getJUnitPreference(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_FACTORY, project.getProject());
	}
	
	public static String getDefaultJUnitTestSuitePath(IJavaProject project) {
		return getJUnitPreference(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_PATH, project.getProject());
	}
	
	public static String getDefaultJUnitTestSuiteType(ICompilationUnit cu) {
		return getJUnitPreference(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_FACTORY, cu.getResource());
	}
	
	public static IPath getResolvedDefaultJUnitTestSuitePath(ICompilationUnit cu) throws CoreException {
		String p = getJUnitPreference(JUnitPreferences.DEFAULT_JUNIT_TEST_SUITE_PATH, cu.getResource());
		IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
		DynamicVariableResolver.setCurrentCompilationUnit(cu);
		try {
			String resolvedP = manager.performStringSubstitution(p);
			Path path = new Path(resolvedP);
			if (path.isAbsolute()) {
				return path;
			} else {
				return path.append(path);
			}
		} finally {
			DynamicVariableResolver.unsetCurrentCompilationUnit();
		}
	}
	
}
