/*******************************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaUtil.java,v 1.2 2010/05/11 17:09:50 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.hyades.test.tools.core.java.JUnitTestSuiteFacade;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

/**
 * <p>Internal test tools core utility APIs wrapping Eclipse JDT APIs.</p>
 * 
 * <p>For public test core utility APIs wrapping Eclipse JDT APIs, see
 * {@link org.eclipse.hyades.test.core.util.JavaUtil}.</p>
 * 
 * <p>For internal UI utility APIs wrapping Eclipse JDT APIs, see
 * {@link org.eclipse.hyades.ui.internal.util.JavaUtil}.</p>

 * 
 * @author  Paul Slauenwhite
 * @version May 11, 2010
 * @since   May 4, 2009
 * @see     org.eclipse.hyades.test.core.util.JavaUtil
 * @see     org.eclipse.hyades.ui.internal.util.JavaUtil
 */
public class JavaUtil{	

	/**
	 * Resolves the {@link IMethod} for the {@link ITestCase} in the generated source code.
	 * 
	 * @param testCase The {@link ITestCase} to be found in the generated source code.
	 * @return The {@link IMethod} for the {@link ITestCase} in the generated source code, otherwise <code>null</code>.
	 */
	public static IMethod findMethod(ITestCase testCase){

		IFile sourceFile = JUnitTestSuiteFacade.getJUnitSourceFile(testCase.getOwner());

		if (sourceFile != null) {

			ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom(sourceFile);

			try {

				if ((compilationUnit.exists()) && (compilationUnit.isStructureKnown())) {

					String methodName = Helper.getTestMethodName(testCase);

					if (methodName != null){

						IType primaryType = compilationUnit.findPrimaryType();

						if (primaryType != null) {

							IMethod[] methods = primaryType.getMethods();

							for (int counter = 0;counter < methods.length;counter++) {

								if ((methodName.equals(methods[counter].getElementName())) && (methods[counter].getParameterTypes().length == 0)) {
									return (methods[counter]);
								}
							}					    	
						}
					}
				}
			} 
			catch (Exception e) {
				CorePlugin.logError(e);
			} 
		}

		return null;
	}
}
