/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IJUnitTestSuiteFactory.java,v 1.3 2007/05/02 19:36:27 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;

/**
 * A factory capable of generating a test suite model from a JUnit source.
 * @author jcanches
 * @since 4.3
 */
public interface IJUnitTestSuiteFactory {

	/**
	 * Returns whether this factory supports test suite generation for a given compilation unit.
	 * @param cu A compilation unit
	 * @return Whether test suite generaton is supported for <code>cu</code>.
	 */
	boolean isSupported(ICompilationUnit cu);
	
	/**
	 * Generates a test suite for a given compilation unit.
	 * @param cu A compilation unit
	 * @return A test suite.
	 */
	ITestSuite generate(ICompilationUnit cu) throws CoreException;

	/**
	 * Determines whether the factory supports test suite generation for compilation
	 * units found in the given project. This method exists for improving performance, and
	 * as such should respond quicky. In no way it should dig into a complete project to check if
	 * there is a supported compilation unit. In case of doubt, it should return <code>true</code>.
	 * @param project A java project.
	 * @return <code>true</code> if this factory may support generation for compilation
	 * units in the project (even if it does not support generation for <strong>all</strong>
	 * the compilation units of the project), and <code>false</code> if it does not support
	 * generation for the project at all.
	 */
	public boolean isSupported(IJavaProject project);
	

}
