/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IJUnitTestSuiteUpdateFactory.java,v 1.3 2007/05/02 19:36:27 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.core.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.jdt.core.ICompilationUnit;

/**
 * A factory capable of generating and updating a test suite model from a compilation
 * unit.
 * @author jcanches
 * @since 4.3
 */
public interface IJUnitTestSuiteUpdateFactory extends IJUnitTestSuiteFactory {

	/**
	 * Updates a test suite model to take the changes occurred in a compilation
	 * unit since the last time the test suite model was generated or updated.
	 * @param testSuite A test suite that has been generated or updated by this
	 * factory in a point in the past.
	 * @param cu A compilation that may have arbitrary changes since the last update
	 * or generation.
	 * @return Whether the testSuite was changed by the update. Returning <code>false</code>
	 * means that the changes in the compilation unit did not have any effect on the test
	 * suite model.
	 */
	boolean update(ITestSuite testSuite, ICompilationUnit cu) throws CoreException;

}
