/********************************************************************** 
 * Copyright (c) 2006, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AgentControllerVerificationService.java,v 1.5 2008/04/09 19:58:03 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.services;

import org.eclipse.hyades.test.core.services.AbstractAgentControllerVerificationService;

/**
 * Agent controller verification service, refer to base class for definition.
 * 
 * One input property of 'connection' and one output property of 'verified', the
 * 'verified' property is set to true if the agent controller is available and
 * also the file system services file server is running
 * 
 * The service identity is 'org.eclipse.hyades.test.core.verify'
 * 
 * @author  Scott E. Schneider
 * @author  Paul E. Slauenwhite
 * @version April 3, 2008
 * @since   March 13, 2006
 */
public class AgentControllerVerificationService extends
		AbstractAgentControllerVerificationService {

	/**
	 * Stream-Unique IDentifier (SUID) of this class.
	 */
	private static final long serialVersionUID = 801702791043246227L;

	/**
	 * Default constructor invokes up hierarchy for any initialization required
	 */
	public AgentControllerVerificationService() {
		super();
	}

}
