/********************************************************************** 
 * Copyright (c) 2007, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ImportExistingProjects.java,v 1.9 2009/11/23 20:25:19 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.services;

import java.io.File;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.automation.server.AbstractWorkspaceSensitiveService;

/**
 * <p>Import existing projects service.</p>
 * 
 * 
 * @author  Joseph Toomey
 * @author  Paul E. Slauenwhite
 * @version November 23, 2009
 * @since   July 26, 2007
 * @provisional As of TPTP V4.4.1 release, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 * @generated
 */
public class ImportExistingProjects extends AbstractWorkspaceSensitiveService
 {

  /**
	 * 
	 */
	private static final long serialVersionUID = 1534094487433262447L;

	/**
	 * @generated
	 */
	private List projectFiles;

	/**
	 * @generated
	 */
	private String projectFile;

	/**
	 * @generated
	 */
	public ImportExistingProjects() {
  }

	/**
	 * @generated NOT
	 */
	public Object execute() {
		// Execute common execute behavior before service specific
		Object object = super.execute();

		// If base class decides to abort this execution early
		//NOTE: When this is changed to IApplication.EXIT_OK, we will need to change it everywhere otherwise this condition may return false since the objects are not the same:
		if (object != IPlatformRunnable.EXIT_OK) {
			return object;
		}
				
		initialize();
		
		// Process the collection of project files, if one has been specified
		if (projectFiles != null) {
			Iterator it = projectFiles.iterator();
			while (it.hasNext()) {
				File theProjectFile = new File((String) it.next());
				if (theProjectFile.exists()) {
					try {
						importProject(theProjectFile);
					} catch (Throwable e) {
						System.out.println("Unable to import project " + theProjectFile.getAbsolutePath());
						e.printStackTrace();
					}
				}
				else 
					System.out.println("Project file does not exist: " + theProjectFile.getAbsolutePath());
			}
		}
		
		// Process the single project file, if one has been specified
		if (projectFile != null) {
			File theProjectFile = new File(projectFile);
			if (theProjectFile.exists()) {
				try {
					importProject(theProjectFile);
				} catch (Throwable e) {
					System.out.println("Unable to import project " + theProjectFile.getAbsolutePath());
					e.printStackTrace();
				}
			}
			else 
				System.out.println("Project file does not exist: " + theProjectFile.getAbsolutePath());
		}
		
		return this;
	}

	private void importProject(File projectFile) throws CoreException {
		System.out.println("Importing project file '" + projectFile.getAbsolutePath() + "'.");
		IPath path = new Path(projectFile.getPath());
		IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription(path);
		String projectName = desc.getName();
		final IWorkspace workspace = ResourcesPlugin.getWorkspace();
		final IProject project = workspace.getRoot().getProject(projectName);
		IProgressMonitor nullProgress = new NullProgressMonitor();
		if (project.exists()){
			System.out.println("Project '" + projectName + "' already exists in workspace.  Refreshing project contents.");
			project.refreshLocal(IResource.DEPTH_INFINITE, nullProgress);
		}
		else {
			project.create(desc, nullProgress);	
			project.open(IResource.NONE, nullProgress);
		}
		
		//Fully (re)build on the workspace:
		workspace.build(IncrementalProjectBuilder.FULL_BUILD, nullProgress);
	}

	/**
	 * @generated
	 */
	private void initialize() {
    // Extract all service parameters
    projectFiles = (List) getProperties().get("projectFiles"); 
    projectFile = getProperty("projectFile"); 
  }

}
