/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: TestExecutionService.java,v 1.16 2007/05/02 19:36:25 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.services;

import org.eclipse.hyades.test.core.services.AbstractTestExecutionService;

/**
 * The test execution service is a public service that is exposed to clients of
 * TPTP -- any test and associated test type that can be launched from the test
 * execution harness can be execute via the test execution service. The test
 * execution service leverages launch configurations to handle the executing of
 * tests in a polymorphic manner. Each test type can define its own launch
 * configuration delegate which allows for different behavior to execute for
 * each particular test type (such as JUnit, manual test, URL test, auto UI,
 * JUnit plug-in test). These launch configuration delegates are already
 * available for the TPTP supported base test types (as well as downstream test
 * types that would be extending from the base TPTP functionality). These are
 * used from the UI when a test is launched via a launch configuration.
 * <p>
 * 
 * Supported properties are (some properties are defined by the concrete service
 * and some are inherited via the base classes)
 * </p>
 * 
 * AbstractWorkspaceCognizantService defines:
 * 
 * <code>
 * 		<ul>
 * 		<li><b>workspace</b> 
 *		  <i>(workspace to run in, optional)</i></li>
 *		<li><b>vmArgs</b>
 *		  <i>(arguments to use for the VM executing the service, optional)</i></li>
 *		</ul>
 * </code>
 * 
 * AbstractTestExecutionService defines:
 * 
 * <code>
 * 		<ul>
 * 		<li><b>connection</b> 
 * 		  <i>(connection string identifying agent controller to use for
 * 		  this test execution, optional, if not specified the most suitable
 * 		  localhost agent controller is assumed)</i></li>
 * 
 * 		<li><b>classpath</b>
 * 		  <i>(classpath for test execution environment, prepended if
 * 		  present, optional)</i></li>
 * 
 * 		<li><b>project</b>
 * 		  <i>(project to run in, optional)</i></li>
 * 
 * 		<li><b>suite</b>
 * 		  <i>(suite to execute, required, relative to project or absolute)</i></li>
 * 
 * 		<li><b>results</b>
 * 		  <i>(results name overrides default, optional, relative to project
 * 		  or absolute)</i></li>
 * 
 *  	<li><b>overwrite</b>
 * 		  <i>(overwrite results and do not create new results named in a way that
 * 		  is derived from results name, optional, default is false)</i></li>
 * 
 * 		<li><b>deployment</b>
 * 		  <i>(deployment to use for test execution, optional, uses default
 * 		  deployment if not specified)</i></li>
 * 		</ul>
 * </code>
 * 
 * Example supported property combinations (set via the ant, shell or other
 * technology specific client adapeters), roughly listed from the least
 * explicitly specified execution to the most specified (examples contain
 * platform specific path specifiers, adjust to the platform where the test
 * lives).
 * <p>
 * 
 * <code>
 * 		<ul>
 * 		<li><b>suite</b>=/home/scotts/tests/A.testsuite</li>
 * 
 * 		<li><b>project</b>=B,  
 * 			<b>suite</b>=B.testsuite</li>
 * 
 * 		<li><b>workspace</b>=/home/scotts/workspace,
 * 			<b>suite</b>=/home/scotts/tests/E.testsuite</li>
 * 
 * 		<li><b>connection</b>=tptp:rac:/192.168.1.112,
 * 			<b>suite</b>=c:/tests/H.testsuite</li>
 * 
 * 		<li><b>workspace</b>=d:\workspace,
 * 			<b>project</b>=C,
 * 			<b>suite</b>=C.testsuite</li>
 * 
 * 		<li><b>connection</b>=tptp:iac:/localhost,
 * 			<b>project</b>=I,
 * 			<b>suite</b>=I.testsuite</li>
 * 
 * 		<li><b>project</b>=D,
 * 			<b>testsuite</b>=D.testsuite,
 * 			<b>deployment</b>=D.deploy</li>
 * 
 * 		<li><b>workspace</b>=d:\workspace,
 * 			<b>project</b>=E,
 * 			<b>suite</b>=E.testsuite,
 * 			<b>deployment</b>=E.deploy,
 * 			<b>results</b>=latestResults.execution</li>
 * 
 * 		<li><b>suite</b>=./tests/E.testsuite,
 * 			<b>results</b>=./tests/results/latestResults.execution,
 * 			<b>classpath</b>=./tests/bin</li>
 * 
 * 		<li><b>connection</b>=tptp:rac:localhost,
 * 			<b>suite</b>=.\tests\F.testsuite,
 * 			<b>results</b>=.\tests\results\latestResults.execution,
 * 			<b>classpath</b>=.\tests\bin;.\aux\bin</li>
 * 			<b>vmArgs</b>=-Xmx640</b>
 * 		</ul>
 * </code>
 * 
 * Typical use cases:
 * <p>
 * <ol>
 * <li>In the case where the tests are executed on a build machine with a
 * workspace that is the default installed with not much change, one would
 * typically specify all absolute paths or relative paths to the current working
 * directory. Classpath would typically be specified and results would be
 * specified.</li>
 * <li>In the case where the tests are executed on a developer machine, in a
 * workspace retrieved from CVS for example, this would usually use the project
 * specified, relative to project format. Workspace, project and testsuite
 * specified, and perhaps deployment for cases where there are multiple
 * deployments to be executed per test (or the test is to be executed on a
 * remote machine)</li>
 * </ol>
 * <p>
 * 
 * @see org.eclipse.hyades.test.core.services.AbstractTestExecutionService
 * 
 * @author Scott E. Schneider
 */
public class TestExecutionService extends AbstractTestExecutionService {

	/**
	 * Stream-Unique IDentifier (SUID) of this class.
	 */
	private static final long serialVersionUID = 1017028791118646227L;

	/**
	 * Default constructor invokes up hierarchy for any initialization required
	 */
	public TestExecutionService() {
		super();
	}

}
