/********************************************************************** 
 * Copyright (c) 2005, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: TestResultsInterrogationService.java,v 1.4 2007/05/02 19:36:25 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.tools.core.services;

import org.eclipse.hyades.test.core.services.AbstractTestResultsInterrogationService;

/**
 * Test results interrogation service, refer to base class for definition.
 * 
 * Three input properties of 'workspace', 'project' and 'results' and one output
 * property of 'verdict', the 'verdict' property is set to one of the valid
 * verdicts defined by the test model, at this time this is defined as pass,
 * fail, error and inconclusive.
 * 
 * The service identity is 'org.eclipse.hyades.test.core.interrogate'
 * 
 * @author Scott E. Schneider
 */
public class TestResultsInterrogationService extends
		AbstractTestResultsInterrogationService {

	/**
	 * Stream-Unique IDentifier (SUID) of this class.
	 */
	private static final long serialVersionUID = 801702791018046227L;

	/**
	 * Default constructor invokes up hierarchy for any initialization required
	 */
	public TestResultsInterrogationService() {
		super();
	}

}
