/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLnodeLoader.java,v 1.3 2008/06/11 20:24:03 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;


public class XMLnodeLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected String hostname;
    protected String ipaddress;
    protected String nodeId;
    protected double timezone;

    //~ Methods ------------------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see org.eclipse.hyades.models.loader.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
     */
    public void addAttribute(String name, String value) {
    	if (value == null || value.trim().length() == 0) 
    		return;
    	
        if (name.equals("nodeId")) {
            nodeId = value;
        } else if (name.equals("hostname")) {
            hostname = value;
        } else if (name.equals("ipaddress")) {
			ipaddress = value;
        } else if (name.equals("timezone")) {
        	timezone = Double.parseDouble(value);
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext(org.eclipse.hyades.models.hierarchy.TRCMonitor)
     */
    public void addYourselfInContext() {
        TRCMonitor monitor = context.getMonitor();

        if (monitor == null) {
            return;
        }

        /* We need a runtimeId to even attempt to create a node */
        if (nodeId == null) {
            // temporary solution until TI agent will provide full set of required node attributes
            nodeId = "0";
        }

        /* If the hostname is not yet set, assign it to be the default */
        if (hostname == null) {
            hostname = Constants.UNKNOWN;
        }

        /* If the node isn't known lets look for it */
        TRCNode node = context.getNode();

        if (node == null) {
            node = LoadersUtils.locateNodeFromMonitor(context.getMonitor(), hostname, ipaddress, nodeId);
        } else {
            String rId = node.getRuntimeId();

            if ((rId != null) && !rId.equals(nodeId)) {
                node = LoadersUtils.locateNodeFromMonitor(monitor, hostname, ipaddress, nodeId);
            }
        }

        if (node == null) {
            //create the node
//            EList nExt = new BasicEList();
            String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource nDoc = null;

            if (monitorFolder != null) {
                String nName = monitor.getName()+ "_" + hostname.trim();

                String nodeFileName = monitorFolder + nName;
                URI uri = SaveUtil.createURI(nodeFileName + ".trcnxmi#").trimFragment();
                nDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
                nDoc.setModified(true);
                HierarchyResourceSetImpl.getInstance().getResources().add(nDoc);

                //*** adding support for multiple files
//                SaveUtil.addDocument(nDoc);
            }

            node = HierarchyFactory.eINSTANCE.createTRCNode();
            node.setName(hostname);
            node.setRuntimeId(nodeId);
            node.setMonitor(monitor);

            if (nDoc != null) {
                nDoc.getContents().add(node);
            }
        } else {
            node.setIpAddress(ipaddress);
            node.setRuntimeId(nodeId);
            node.setTimezone(timezone);
        }

		context.setNode(node);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        hostname = null;
        ipaddress = null;
        nodeId = null;
        timezone = 0;
    }
}
