/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFParserFactory.java,v 1.2 2008/03/24 23:13:18 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.hyades.loaders.internal.binary.v1.ParserImpl1;
import org.eclipse.hyades.loaders.util.HierarchyContext;

public class BFParserFactory {
	private static final Class[] constructorArgs = new Class[] {HierarchyContext.class, BFReader.class};
	
	private final Map parsers = new HashMap();
	
	public BFParserFactory() {
		ParserImpl1.register(this);
	}
	
	public BFParser get(BFHeader header, HierarchyContext context, BFReader reader) {
		Class parserClass = (Class) parsers.get(new Double(header.getVersion().getVersion()));
		if (parserClass == null) {
			return null;
		}
			
		try {
			return (BFParser) parserClass.getConstructor(constructorArgs).newInstance(new Object[] {context, reader});
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		
		return null;
	}

	public void put(Double version, Class parser) {
		parsers.put(version, parser);
	}
}
