/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFMethodDefParser.java,v 1.2 2008/03/24 23:08:03 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFMethodDefParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short)1012);

	public static final String NAME = "methodDef";

	public BFMethodDefParser() {
		super(ID, NAME);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();


		loader.addAttribute(NAME_ATTR, reader.readString(data, offset));
		loader.addAttribute(SIGNATURE, reader.readString(data, offset));
		loader.addAttribute(VISIBILITY, reader.readString(data, offset));
		loader.addAttribute(IS_NATIVE, reader.readByte(data, offset));
		loader.addAttribute(IS_ABSTRACT, reader.readByte(data, offset));
		loader.addAttribute(IS_STATIC, reader.readByte(data, offset));
		loader.addAttribute(IS_SYNCHRONIZED, reader.readByte(data, offset));
		loader.addAttribute(EXCEPTIONS, reader.readString(data, offset));
		loader.addAttribute(START_LINE_NUMBER, (int) reader.readLong(data, offset));
		loader.addAttribute(END_LINE_NUMBER, (int) reader.readLong(data, offset));
		loader.addAttribute(SIGNATURE_NOTATION, reader.readString(data, offset));
		loader.addAttribute(TRANS_CLASS_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(CLASS_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(METHOD_ID, (int)reader.readLong(data, offset));
		loader.addAttribute(COLLATION_VALUE, reader.readString(data, offset));
		loader.addAttribute(TRACE_ID_REF, reader.readString(data, offset));
		
		return true;
	}
}
