/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFMonContendedEnterParser.java,v 1.3 2008/05/19 14:49:54 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFMonContendedEnterParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short) 1034);
	
	public static final String NAME = "monContendedEnter"; 

	public BFMonContendedEnterParser() {
		super(ID, NAME);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(THREAD_ID_REF, (int) reader.readLong(data, offset));
		loader.addAttribute(TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(OBJ_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(THREAD_OWNER, (int) reader.readLong(data, offset));
		
		long stackDepth = reader.readUnsignedInt(data, offset);
		
		String[] stackMethods = reader.readStringArray(data, (int)stackDepth, offset); // Possible truncation
		addAnnotation(loader, stackMethods, CALL_STACK_METHODS);

		Long[] stackLines = reader.readLongArray(data, (int)stackDepth, offset);
		addAnnotation(loader, stackLines, CALL_STACK_LINES);
		
		return true;
	}
}
