/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFObjAllocParser.java,v 1.4 2008/05/19 14:49:55 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFObjAllocParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short)1013);

	public static final String NAME = "objAlloc";

	public BFObjAllocParser() {
		super(ID, NAME);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(TRANS_THREAD_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(THREAD_ID_REF, (int)reader.readLong(data, offset));
		loader.addAttribute(TIME, reader.readTimestampAsString(data, offset));
		loader.addAttribute(IS_ARRAY, reader.readByte(data, offset));
		loader.addAttribute(TRANS_OBJ_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(OBJ_ID, reader.readLong(data, offset));
		loader.addAttribute(SIZE, (int) reader.readLong(data, offset));
		loader.addAttribute(A_LINE_NR, (int) reader.readLong(data, offset));
		loader.addAttribute(A_METHOD_ID_REF, (int)reader.readLong(data, offset));
		loader.addAttribute(TRANS_CLASS_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(CLASS_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(CONTEXT_DATA, reader.readString(data, offset));
		loader.addAttribute(COLLATION_VALUE, reader.readString(data, offset));
		loader.addAttribute(TRACE_ID_REF, reader.readString(data, offset));
		
		return true;
	}
}
