/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BFObjRefParser.java,v 1.2 2008/03/24 23:08:03 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFObjRefParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short)1040);
	
	public static final String NAME = "objReference"; 

	public BFObjRefParser() {
		super(ID, NAME);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(OWNER_OBJ_ID_REF, (int)reader.readLong(data, offset));
		loader.addAttribute(TARGET_OBJ_ID_REF, reader.readLong(data, offset));
		loader.addAttribute(HEAP_DUMP_ID_REF, (short) reader.readLong(data, offset));
		
		return true;
	}
}
