/**********************************************************************
 * Copyright (c) 2010 IBM Corporation
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: BFThreadSleepEndParser.java,v 1.1 2010/05/11 16:30:00 jwest Exp $
 *
 **********************************************************************/

package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFThreadSleepEndParser extends BinaryFragmentParser {

	public static final Short ID = new Short((short) 1046);
	
	public static final String NAME = "threadSleepEnd"; 

	public BFThreadSleepEndParser() {
		super(ID, NAME);
	}
	
	protected BFThreadSleepEndParser(Short id, String name) {
		super(id, name);
	}
	
	public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
		byte[] data = fragment.getBody();
		BinaryFragmentLoader loader = getLoader();

		loader.addAttribute(THREAD_ID_REF, (int) reader.readLong(data, offset));
		loader.addAttribute(TIME, reader.readTimestampAsString(data, offset));
		
		return true;
	}
}
