/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentProxyContext.java,v 1.2 2008/01/24 02:28:17 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;


public class AgentProxyContext {
    protected TRCAgentProxy agentProxy;
    protected TRCCollectionMode collectionMode = TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
    protected boolean loadToModel = true;
    protected Object agentListener;
	protected Object agentInstance;
	protected XMLLoader dataProcessor;
    

	/**
	 * 
	 */
	public AgentProxyContext() {
		super();
	}

    /**
     * Sets the agentProxy.
     * @param agentProxy The agentProxy to set
     */
    public void setAgentProxy(TRCAgentProxy agentProxy) {
        this.agentProxy = agentProxy;
    }

    /**
     * @return TRCAgentProxy
     */
    public TRCAgentProxy getAgentProxy() {
        return agentProxy;
    }

    /**
     * Sets the collectionMode.
     * @param collectionMode The collectionMode to set
     */
    public void setCollectionMode(TRCCollectionMode collectionMode) {
        this.collectionMode = collectionMode;
    }

    /**
     * @return TRCCollectionMode
     */
    public TRCCollectionMode getCollectionMode() {
        return collectionMode;
    }

    /**
     * Sets the loadToModel.
     * @param loadToModel The loadToModel to set
     */
    public void setLoadToModel(boolean loadToModel) {
        this.loadToModel = loadToModel;
    }

    /**
     * @return boolean
     */
    public boolean isLoadToModel() {
        return loadToModel;
    }

	/**
	 * @return
	 */
	public Object getAgentListener() {
		return agentListener;
	}

	/**
	 * @return
	 */
	public XMLLoader getDataProcessor() {
		return dataProcessor;
	}

	/**
	 * @param object
	 */
	public void setAgentListener(Object object) {
		agentListener = object;
	}

	/**
	 * @param loader
	 */
	public void setDataProcessor(XMLLoader loader) {
		dataProcessor = loader;
	}

	/**
	 * @return
	 */
	public Object getAgentInstance() {
		return agentInstance;
	}

	/**
	 * @param object
	 */
	public void setAgentInstance(Object object) {
		agentInstance = object;
	}
	public void cleanUp() {
		this.agentProxy = null;
		this.collectionMode = null;
		this.agentListener = null;
		this.agentInstance = null;
		this.dataProcessor = null;
	}
}
