/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLFragmentLoader.java,v 1.2 2007/12/01 00:06:18 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

public interface XMLFragmentLoader {
    //~ Methods ------------------------------------------------------------------------------------

    void addAttribute(String name, String value);

    void addCharacters(char[] data, int offset, int length);

    /**
     * This is called on end of root element of each fragment
     */
    void addYourselfInContext();

    /**
     * This is called at the end of the document.
     */
    void cleanUp();

    void endChild(String name);

    /**
     * This is called on start of root element of each fragment
     */
    void initialize(HierarchyContext context, String name);

    void startChild(String name);
}
