/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCAgent.java,v 1.3 2009/05/05 15:45:21 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Agent</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * An agent is analogous to a "trace file". An agent is typed to hold a particular type of trace, and the TRCAgent object owns by value the instances of the trace data. Because agents are typed, there can be zero or more agents associated with a given TRCMonitor, TRCNode or TRCProcessProxy. However, a given agent instance can only be associated with one of those objects.
 * 
 * This agent is the model entity for a data provider.  Providers provide metadata as a collection of descriptors and the data itself as observations. 
 * 
 * The agent is also the granularity of persistence.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getCollectionMode <em>Collection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getDefaultEvents <em>Default Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getView <em>View</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getDescriptor <em>Descriptor</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getAgentProxy <em>Agent Proxy</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getUnresolvedCorrelations <em>Unresolved Correlations</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent()
 * @model
 * @generated
 */
public interface TRCAgent extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A descriptive agent name, like "Java Profiler Agent"
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The default value is <code>"_unknown"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The type of the agent, eg. "Profiler"
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_Type()
	 * @model default="_unknown"
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Runtime Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A GUID based ID to identify an monitoring agent instance
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Runtime Id</em>' attribute.
	 * @see #setRuntimeId(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_RuntimeId()
	 * @model
	 * @generated
	 */
	String getRuntimeId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getRuntimeId <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Runtime Id</em>' attribute.
	 * @see #getRuntimeId()
	 * @generated
	 */
	void setRuntimeId(String value);

	/**
	 * Returns the value of the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Start Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Marks the starting point of the collecting session
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Time</em>' attribute.
	 * @see #setStartTime(double)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_StartTime()
	 * @model
	 * @generated
	 */
	double getStartTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getStartTime <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Time</em>' attribute.
	 * @see #getStartTime()
	 * @generated
	 */
	void setStartTime(double value);

	/**
	 * Returns the value of the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Stop Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Marks the end point of the collecting session
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stop Time</em>' attribute.
	 * @see #setStopTime(double)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_StopTime()
	 * @model
	 * @generated
	 */
	double getStopTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getStopTime <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stop Time</em>' attribute.
	 * @see #getStopTime()
	 * @generated
	 */
	void setStopTime(double value);

	/**
	 * Returns the value of the '<em><b>Collection Mode</b></em>' attribute.
	 * The default value is <code>"HEAP_STATISTICS_ONLY"</code>.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.hierarchy.TRCCollectionMode}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collection Mode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Defines different collection modes (some include filtering of data on agent side some on loader side and some are combined). This is used by loaders and UI to decide the model building algorithms and the presentation mode. This is has the same value as TRCAgentProxy.collectionMode attribute.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collection Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @see #setCollectionMode(TRCCollectionMode)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_CollectionMode()
	 * @model default="HEAP_STATISTICS_ONLY"
	 * @generated
	 */
	TRCCollectionMode getCollectionMode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getCollectionMode <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collection Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @see #getCollectionMode()
	 * @generated
	 */
	void setCollectionMode(TRCCollectionMode value);

	/**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The version of an agent (for example "1.0.0")
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_Version()
	 * @model
	 * @generated
	 */
	String getVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getVersion <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Version</em>' attribute.
	 * @see #getVersion()
	 * @generated
	 */
	void setVersion(String value);

	/**
	 * Returns the value of the '<em><b>Default Events</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Events</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Events</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_DefaultEvents()
	 * @see org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent#getAgent
	 * @model opposite="agent" containment="true"
	 * @generated
	 */
	EList<AbstractDefaultEvent> getDefaultEvents();

	/**
	 * Returns the value of the '<em><b>Agent Proxy</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Agent Proxy</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Agent Proxy</em>' reference.
	 * @see #setAgentProxy(TRCAgentProxy)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_AgentProxy()
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getAgent
	 * @model opposite="agent"
	 * @generated
	 */
	TRCAgentProxy getAgentProxy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getAgentProxy <em>Agent Proxy</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Agent Proxy</em>' reference.
	 * @see #getAgentProxy()
	 * @generated
	 */
	void setAgentProxy(TRCAgentProxy value);

	/**
	 * Returns the value of the '<em><b>Unresolved Correlations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Unresolved Correlations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Unresolved Correlations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_UnresolvedCorrelations()
	 * @see org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getAgent
	 * @model opposite="agent" containment="true"
	 * @generated
	 */
	EList<UnresolvedCorrelation> getUnresolvedCorrelations();

	/**
	 * Returns the value of the '<em><b>View</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCView#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>View</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>View</em>' containment reference.
	 * @see #setView(AbstractTRCView)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_View()
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCView#getAgent
	 * @model opposite="agent" containment="true"
	 * @generated
	 */
	AbstractTRCView getView();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getView <em>View</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>View</em>' containment reference.
	 * @see #getView()
	 * @generated
	 */
	void setView(AbstractTRCView value);

	/**
	 * Returns the value of the '<em><b>Descriptor</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.AbstractTRCDescription}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCDescription#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Descriptor</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Descriptor</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_Descriptor()
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCDescription#getAgent
	 * @model opposite="agent" containment="true"
	 * @generated
	 */
	EList<AbstractTRCDescription> getDescriptor();

	/**
	 * Returns the value of the '<em><b>Process</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCProcess#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process</em>' containment reference.
	 * @see #setProcess(AbstractTRCProcess)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgent_Process()
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCProcess#getAgent
	 * @model opposite="agent" containment="true"
	 * @generated
	 */
	AbstractTRCProcess getProcess();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getProcess <em>Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process</em>' containment reference.
	 * @see #getProcess()
	 * @generated
	 */
	void setProcess(AbstractTRCProcess value);

} // TRCAgent
