/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ExtensionsPackage.java,v 1.2 2007/12/01 00:06:22 apnan Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Resource extensions (internal code)
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory
 * @model kind="package"
 * @generated
 */
public interface ExtensionsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "extensions";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/hierarchy-extensions.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "HierarchyExtensions";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ExtensionsPackage eINSTANCE = org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl <em>Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getQuery()
	 * @generated
	 */
	int QUERY = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__SOURCES = 1;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__DISTINCT = 2;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__COUNT = 3;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__OUTPUT_ELEMENTS = 4;

	/**
	 * The feature id for the '<em><b>Sub Query</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__SUB_QUERY = 5;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__QUERY = 6;

	/**
	 * The feature id for the '<em><b>Required Paths</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__REQUIRED_PATHS = 7;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY__ANNOTATIONS = 8;

	/**
	 * The number of structural features of the '<em>Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_FEATURE_COUNT = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl <em>Simple Search Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getSimpleSearchQuery()
	 * @generated
	 */
	int SIMPLE_SEARCH_QUERY = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__NAME = QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__SOURCES = QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__DISTINCT = QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__COUNT = QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS = QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Sub Query</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__SUB_QUERY = QUERY__SUB_QUERY;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__QUERY = QUERY__QUERY;

	/**
	 * The feature id for the '<em><b>Required Paths</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__REQUIRED_PATHS = QUERY__REQUIRED_PATHS;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__ANNOTATIONS = QUERY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__MAX_ELEMENTS = QUERY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Start With</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__START_WITH = QUERY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Order By Expresions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS = QUERY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Where Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION = QUERY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Simple Search Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_SEARCH_QUERY_FEATURE_COUNT = QUERY_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.InstanceQueryImpl <em>Instance Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.InstanceQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getInstanceQuery()
	 * @generated
	 */
	int INSTANCE_QUERY = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__NAME = QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__SOURCES = QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__DISTINCT = QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__COUNT = QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__OUTPUT_ELEMENTS = QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Sub Query</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__SUB_QUERY = QUERY__SUB_QUERY;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__QUERY = QUERY__QUERY;

	/**
	 * The feature id for the '<em><b>Required Paths</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__REQUIRED_PATHS = QUERY__REQUIRED_PATHS;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__ANNOTATIONS = QUERY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Conditions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY__CONDITIONS = QUERY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Instance Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INSTANCE_QUERY_FEATURE_COUNT = QUERY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl <em>Order By Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOrderByElement()
	 * @generated
	 */
	int ORDER_BY_ELEMENT = 3;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT__OPERATOR = 0;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT__OPERAND = 1;

	/**
	 * The feature id for the '<em><b>Search Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT__SEARCH_QUERY = 2;

	/**
	 * The number of structural features of the '<em>Order By Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORDER_BY_ELEMENT_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryResultImpl <em>Query Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.QueryResultImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getQueryResult()
	 * @generated
	 */
	int QUERY_RESULT = 4;

	/**
	 * The feature id for the '<em><b>Query</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_RESULT__QUERY = 0;

	/**
	 * The feature id for the '<em><b>Result Entries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_RESULT__RESULT_ENTRIES = 1;

	/**
	 * The number of structural features of the '<em>Query Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUERY_RESULT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.WhereExpressionImpl <em>Where Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.WhereExpressionImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getWhereExpression()
	 * @generated
	 */
	int WHERE_EXPRESSION = 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHERE_EXPRESSION__NAME = 0;

	/**
	 * The feature id for the '<em><b>Search Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHERE_EXPRESSION__SEARCH_QUERY = 1;

	/**
	 * The number of structural features of the '<em>Where Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHERE_EXPRESSION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl <em>Binary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getBinaryExpression()
	 * @generated
	 */
	int BINARY_EXPRESSION = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__NAME = WHERE_EXPRESSION__NAME;

	/**
	 * The feature id for the '<em><b>Search Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__SEARCH_QUERY = WHERE_EXPRESSION__SEARCH_QUERY;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__OPERATOR = WHERE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__LEFT_OPERAND = WHERE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right Operands</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__RIGHT_OPERANDS = WHERE_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Case Insensitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__CASE_INSENSITIVE = WHERE_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Instance Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__INSTANCE_QUERY = WHERE_EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Binary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION_FEATURE_COUNT = WHERE_EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OperandImpl <em>Operand</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.OperandImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOperand()
	 * @generated
	 */
	int OPERAND = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERAND__NAME = 0;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERAND__QUERY = 1;

	/**
	 * The number of structural features of the '<em>Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERAND_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.ResultEntryImpl <em>Result Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ResultEntryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getResultEntry()
	 * @generated
	 */
	int RESULT_ENTRY = 7;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_ENTRY__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Result Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_ENTRY_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl <em>Correlation Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getCorrelationQuery()
	 * @generated
	 */
	int CORRELATION_QUERY = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__NAME = SIMPLE_SEARCH_QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__SOURCES = SIMPLE_SEARCH_QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__DISTINCT = SIMPLE_SEARCH_QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__COUNT = SIMPLE_SEARCH_QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__OUTPUT_ELEMENTS = SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Sub Query</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__SUB_QUERY = SIMPLE_SEARCH_QUERY__SUB_QUERY;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__QUERY = SIMPLE_SEARCH_QUERY__QUERY;

	/**
	 * The feature id for the '<em><b>Required Paths</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__REQUIRED_PATHS = SIMPLE_SEARCH_QUERY__REQUIRED_PATHS;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__ANNOTATIONS = SIMPLE_SEARCH_QUERY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__MAX_ELEMENTS = SIMPLE_SEARCH_QUERY__MAX_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Start With</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__START_WITH = SIMPLE_SEARCH_QUERY__START_WITH;

	/**
	 * The feature id for the '<em><b>Order By Expresions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__ORDER_BY_EXPRESIONS = SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS;

	/**
	 * The feature id for the '<em><b>Where Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__WHERE_EXPRESSION = SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Correlation Container URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__CORRELATION_CONTAINER_URI = SIMPLE_SEARCH_QUERY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Correlation Container Proxy URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI = SIMPLE_SEARCH_QUERY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Delta Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY__DELTA_TIME = SIMPLE_SEARCH_QUERY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Correlation Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_QUERY_FEATURE_COUNT = SIMPLE_SEARCH_QUERY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.TimeBasedCorrelationQueryImpl <em>Time Based Correlation Query</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.TimeBasedCorrelationQueryImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getTimeBasedCorrelationQuery()
	 * @generated
	 */
	int TIME_BASED_CORRELATION_QUERY = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__NAME = CORRELATION_QUERY__NAME;

	/**
	 * The feature id for the '<em><b>Sources</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__SOURCES = CORRELATION_QUERY__SOURCES;

	/**
	 * The feature id for the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__DISTINCT = CORRELATION_QUERY__DISTINCT;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__COUNT = CORRELATION_QUERY__COUNT;

	/**
	 * The feature id for the '<em><b>Output Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__OUTPUT_ELEMENTS = CORRELATION_QUERY__OUTPUT_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Sub Query</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__SUB_QUERY = CORRELATION_QUERY__SUB_QUERY;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__QUERY = CORRELATION_QUERY__QUERY;

	/**
	 * The feature id for the '<em><b>Required Paths</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__REQUIRED_PATHS = CORRELATION_QUERY__REQUIRED_PATHS;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__ANNOTATIONS = CORRELATION_QUERY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__MAX_ELEMENTS = CORRELATION_QUERY__MAX_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Start With</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__START_WITH = CORRELATION_QUERY__START_WITH;

	/**
	 * The feature id for the '<em><b>Order By Expresions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__ORDER_BY_EXPRESIONS = CORRELATION_QUERY__ORDER_BY_EXPRESIONS;

	/**
	 * The feature id for the '<em><b>Where Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__WHERE_EXPRESSION = CORRELATION_QUERY__WHERE_EXPRESSION;

	/**
	 * The feature id for the '<em><b>Correlation Container URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__CORRELATION_CONTAINER_URI = CORRELATION_QUERY__CORRELATION_CONTAINER_URI;

	/**
	 * The feature id for the '<em><b>Correlation Container Proxy URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI = CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI;

	/**
	 * The feature id for the '<em><b>Delta Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY__DELTA_TIME = CORRELATION_QUERY__DELTA_TIME;

	/**
	 * The number of structural features of the '<em>Time Based Correlation Query</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_BASED_CORRELATION_QUERY_FEATURE_COUNT = CORRELATION_QUERY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.LogicalExpressionImpl <em>Logical Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.LogicalExpressionImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getLogicalExpression()
	 * @generated
	 */
	int LOGICAL_EXPRESSION = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__NAME = WHERE_EXPRESSION__NAME;

	/**
	 * The feature id for the '<em><b>Search Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__SEARCH_QUERY = WHERE_EXPRESSION__SEARCH_QUERY;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__OPERATOR = WHERE_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__ARGUMENTS = WHERE_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Logical Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION_FEATURE_COUNT = WHERE_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.ArithmeticExpressionImpl <em>Arithmetic Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ArithmeticExpressionImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getArithmeticExpression()
	 * @generated
	 */
	int ARITHMETIC_EXPRESSION = 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__NAME = OPERAND__NAME;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__QUERY = OPERAND__QUERY;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__OPERATOR = OPERAND_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__ARGUMENTS = OPERAND_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Arithmetic Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION_FEATURE_COUNT = OPERAND_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.NumericFunctionImpl <em>Numeric Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.NumericFunctionImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getNumericFunction()
	 * @generated
	 */
	int NUMERIC_FUNCTION = 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_FUNCTION__NAME = OPERAND__NAME;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_FUNCTION__QUERY = OPERAND__QUERY;

	/**
	 * The feature id for the '<em><b>Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_FUNCTION__FUNCTION = OPERAND_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Arguments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_FUNCTION__ARGUMENTS = OPERAND_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Numeric Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_FUNCTION_FEATURE_COUNT = OPERAND_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl <em>Simple Operand</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getSimpleOperand()
	 * @generated
	 */
	int SIMPLE_OPERAND = 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND__NAME = OPERAND__NAME;

	/**
	 * The feature id for the '<em><b>Query</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND__QUERY = OPERAND__QUERY;

	/**
	 * The feature id for the '<em><b>Raw Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND__RAW_VALUE = OPERAND_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND__VALUE = OPERAND_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND__FEATURE = OPERAND_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND__TYPE = OPERAND_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Value Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND__VALUE_TYPE = OPERAND_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Simple Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_OPERAND_FEATURE_COUNT = OPERAND_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators <em>Relational Operators</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getRelationalOperators()
	 * @generated
	 */
	int RELATIONAL_OPERATORS = 15;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators <em>Order By Operators</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOrderByOperators()
	 * @generated
	 */
	int ORDER_BY_OPERATORS = 16;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators <em>Logical Operators</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getLogicalOperators()
	 * @generated
	 */
	int LOGICAL_OPERATORS = 17;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.ArithmeticOperators <em>Arithmetic Operators</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ArithmeticOperators
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getArithmeticOperators()
	 * @generated
	 */
	int ARITHMETIC_OPERATORS = 18;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions <em>Numeric Functions</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions
	 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getNumericFunctions()
	 * @generated
	 */
	int NUMERIC_FUNCTIONS = 19;

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.Query <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query
	 * @generated
	 */
	EClass getQuery();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getName()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Name();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSources <em>Sources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Sources</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getSources()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Sources();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct <em>Distinct</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distinct</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Distinct();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isCount <em>Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Count</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#isCount()
	 * @see #getQuery()
	 * @generated
	 */
	EAttribute getQuery_Count();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getOutputElements <em>Output Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Output Elements</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getOutputElements()
	 * @see #getQuery()
	 * @generated
	 */
	EReference getQuery_OutputElements();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery <em>Sub Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sub Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery()
	 * @see #getQuery()
	 * @generated
	 */
	EReference getQuery_SubQuery();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery()
	 * @see #getQuery()
	 * @generated
	 */
	EReference getQuery_Query();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getRequiredPaths <em>Required Paths</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Required Paths</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getRequiredPaths()
	 * @see #getQuery()
	 * @generated
	 */
	EReference getQuery_RequiredPaths();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getAnnotations <em>Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotations</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getAnnotations()
	 * @see #getQuery()
	 * @generated
	 */
	EReference getQuery_Annotations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery <em>Simple Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Search Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery
	 * @generated
	 */
	EClass getSimpleSearchQuery();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getMaxElements <em>Max Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Elements</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getMaxElements()
	 * @see #getSimpleSearchQuery()
	 * @generated
	 */
	EAttribute getSimpleSearchQuery_MaxElements();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getStartWith <em>Start With</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start With</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getStartWith()
	 * @see #getSimpleSearchQuery()
	 * @generated
	 */
	EAttribute getSimpleSearchQuery_StartWith();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getOrderByExpresions <em>Order By Expresions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Order By Expresions</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getOrderByExpresions()
	 * @see #getSimpleSearchQuery()
	 * @generated
	 */
	EReference getSimpleSearchQuery_OrderByExpresions();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpression <em>Where Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Where Expression</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpression()
	 * @see #getSimpleSearchQuery()
	 * @generated
	 */
	EReference getSimpleSearchQuery_WhereExpression();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery <em>Instance Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Instance Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery
	 * @generated
	 */
	EClass getInstanceQuery();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Conditions</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions()
	 * @see #getInstanceQuery()
	 * @generated
	 */
	EReference getInstanceQuery_Conditions();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement <em>Order By Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Order By Element</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement
	 * @generated
	 */
	EClass getOrderByElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperator()
	 * @see #getOrderByElement()
	 * @generated
	 */
	EAttribute getOrderByElement_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperand <em>Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getOperand()
	 * @see #getOrderByElement()
	 * @generated
	 */
	EReference getOrderByElement_Operand();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getSearchQuery <em>Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Search Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getSearchQuery()
	 * @see #getOrderByElement()
	 * @generated
	 */
	EReference getOrderByElement_SearchQuery();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.QueryResult <em>Query Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Query Result</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.QueryResult
	 * @generated
	 */
	EClass getQueryResult();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getQuery()
	 * @see #getQueryResult()
	 * @generated
	 */
	EReference getQueryResult_Query();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getResultEntries <em>Result Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Result Entries</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.QueryResult#getResultEntries()
	 * @see #getQueryResult()
	 * @generated
	 */
	EReference getQueryResult_ResultEntries();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression <em>Binary Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Binary Expression</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression
	 * @generated
	 */
	EClass getBinaryExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getOperator()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EAttribute getBinaryExpression_Operator();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getLeftOperand <em>Left Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getLeftOperand()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EReference getBinaryExpression_LeftOperand();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getRightOperands <em>Right Operands</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Right Operands</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getRightOperands()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EReference getBinaryExpression_RightOperands();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#isCaseInsensitive <em>Case Insensitive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Case Insensitive</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#isCaseInsensitive()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EAttribute getBinaryExpression_CaseInsensitive();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getInstanceQuery <em>Instance Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Instance Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression#getInstanceQuery()
	 * @see #getBinaryExpression()
	 * @generated
	 */
	EReference getBinaryExpression_InstanceQuery();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.Operand <em>Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Operand
	 * @generated
	 */
	EClass getOperand();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.Operand#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Operand#getName()
	 * @see #getOperand()
	 * @generated
	 */
	EAttribute getOperand_Name();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.Operand#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Operand#getQuery()
	 * @see #getOperand()
	 * @generated
	 */
	EReference getOperand_Query();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.ResultEntry <em>Result Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Result Entry</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ResultEntry
	 * @generated
	 */
	EClass getResultEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.ResultEntry#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ResultEntry#getValue()
	 * @see #getResultEntry()
	 * @generated
	 */
	EAttribute getResultEntry_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery <em>Correlation Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Correlation Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery
	 * @generated
	 */
	EClass getCorrelationQuery();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getCorrelationContainerURI <em>Correlation Container URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Correlation Container URI</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getCorrelationContainerURI()
	 * @see #getCorrelationQuery()
	 * @generated
	 */
	EAttribute getCorrelationQuery_CorrelationContainerURI();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getCorrelationContainerProxyURI <em>Correlation Container Proxy URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Correlation Container Proxy URI</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getCorrelationContainerProxyURI()
	 * @see #getCorrelationQuery()
	 * @generated
	 */
	EAttribute getCorrelationQuery_CorrelationContainerProxyURI();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getDeltaTime <em>Delta Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Delta Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery#getDeltaTime()
	 * @see #getCorrelationQuery()
	 * @generated
	 */
	EAttribute getCorrelationQuery_DeltaTime();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery <em>Time Based Correlation Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Time Based Correlation Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery
	 * @generated
	 */
	EClass getTimeBasedCorrelationQuery();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression <em>Logical Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Logical Expression</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression
	 * @generated
	 */
	EClass getLogicalExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression#getOperator()
	 * @see #getLogicalExpression()
	 * @generated
	 */
	EAttribute getLogicalExpression_Operator();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression#getArguments <em>Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Arguments</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression#getArguments()
	 * @see #getLogicalExpression()
	 * @generated
	 */
	EReference getLogicalExpression_Arguments();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.WhereExpression <em>Where Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Where Expression</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.WhereExpression
	 * @generated
	 */
	EClass getWhereExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.WhereExpression#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.WhereExpression#getName()
	 * @see #getWhereExpression()
	 * @generated
	 */
	EAttribute getWhereExpression_Name();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.extensions.WhereExpression#getSearchQuery <em>Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Search Query</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.WhereExpression#getSearchQuery()
	 * @see #getWhereExpression()
	 * @generated
	 */
	EReference getWhereExpression_SearchQuery();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression <em>Arithmetic Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Arithmetic Expression</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression
	 * @generated
	 */
	EClass getArithmeticExpression();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression#getOperator()
	 * @see #getArithmeticExpression()
	 * @generated
	 */
	EAttribute getArithmeticExpression_Operator();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression#getArguments <em>Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Arguments</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression#getArguments()
	 * @see #getArithmeticExpression()
	 * @generated
	 */
	EReference getArithmeticExpression_Arguments();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunction <em>Numeric Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Numeric Function</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunction
	 * @generated
	 */
	EClass getNumericFunction();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunction#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Function</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunction#getFunction()
	 * @see #getNumericFunction()
	 * @generated
	 */
	EAttribute getNumericFunction_Function();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunction#getArguments <em>Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Arguments</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunction#getArguments()
	 * @see #getNumericFunction()
	 * @generated
	 */
	EReference getNumericFunction_Arguments();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand <em>Simple Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Operand</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand
	 * @generated
	 */
	EClass getSimpleOperand();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getRawValue <em>Raw Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Raw Value</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getRawValue()
	 * @see #getSimpleOperand()
	 * @generated
	 */
	EAttribute getSimpleOperand_RawValue();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getValue()
	 * @see #getSimpleOperand()
	 * @generated
	 */
	EAttribute getSimpleOperand_Value();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getFeature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Feature</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getFeature()
	 * @see #getSimpleOperand()
	 * @generated
	 */
	EReference getSimpleOperand_Feature();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getType()
	 * @see #getSimpleOperand()
	 * @generated
	 */
	EReference getSimpleOperand_Type();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getValueType <em>Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Value Type</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand#getValueType()
	 * @see #getSimpleOperand()
	 * @generated
	 */
	EReference getSimpleOperand_ValueType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators <em>Relational Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Relational Operators</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @generated
	 */
	EEnum getRelationalOperators();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators <em>Order By Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Order By Operators</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators
	 * @generated
	 */
	EEnum getOrderByOperators();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators <em>Logical Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Logical Operators</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators
	 * @generated
	 */
	EEnum getLogicalOperators();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.extensions.ArithmeticOperators <em>Arithmetic Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Arithmetic Operators</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ArithmeticOperators
	 * @generated
	 */
	EEnum getArithmeticOperators();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions <em>Numeric Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Numeric Functions</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions
	 * @generated
	 */
	EEnum getNumericFunctions();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ExtensionsFactory getExtensionsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl <em>Query</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getQuery()
		 * @generated
		 */
		EClass QUERY = eINSTANCE.getQuery();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QUERY__NAME = eINSTANCE.getQuery_Name();

		/**
		 * The meta object literal for the '<em><b>Sources</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QUERY__SOURCES = eINSTANCE.getQuery_Sources();

		/**
		 * The meta object literal for the '<em><b>Distinct</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QUERY__DISTINCT = eINSTANCE.getQuery_Distinct();

		/**
		 * The meta object literal for the '<em><b>Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QUERY__COUNT = eINSTANCE.getQuery_Count();

		/**
		 * The meta object literal for the '<em><b>Output Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY__OUTPUT_ELEMENTS = eINSTANCE.getQuery_OutputElements();

		/**
		 * The meta object literal for the '<em><b>Sub Query</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY__SUB_QUERY = eINSTANCE.getQuery_SubQuery();

		/**
		 * The meta object literal for the '<em><b>Query</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY__QUERY = eINSTANCE.getQuery_Query();

		/**
		 * The meta object literal for the '<em><b>Required Paths</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY__REQUIRED_PATHS = eINSTANCE.getQuery_RequiredPaths();

		/**
		 * The meta object literal for the '<em><b>Annotations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY__ANNOTATIONS = eINSTANCE.getQuery_Annotations();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl <em>Simple Search Query</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getSimpleSearchQuery()
		 * @generated
		 */
		EClass SIMPLE_SEARCH_QUERY = eINSTANCE.getSimpleSearchQuery();

		/**
		 * The meta object literal for the '<em><b>Max Elements</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SIMPLE_SEARCH_QUERY__MAX_ELEMENTS = eINSTANCE.getSimpleSearchQuery_MaxElements();

		/**
		 * The meta object literal for the '<em><b>Start With</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SIMPLE_SEARCH_QUERY__START_WITH = eINSTANCE.getSimpleSearchQuery_StartWith();

		/**
		 * The meta object literal for the '<em><b>Order By Expresions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS = eINSTANCE.getSimpleSearchQuery_OrderByExpresions();

		/**
		 * The meta object literal for the '<em><b>Where Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION = eINSTANCE.getSimpleSearchQuery_WhereExpression();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.InstanceQueryImpl <em>Instance Query</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.InstanceQueryImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getInstanceQuery()
		 * @generated
		 */
		EClass INSTANCE_QUERY = eINSTANCE.getInstanceQuery();

		/**
		 * The meta object literal for the '<em><b>Conditions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INSTANCE_QUERY__CONDITIONS = eINSTANCE.getInstanceQuery_Conditions();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl <em>Order By Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOrderByElement()
		 * @generated
		 */
		EClass ORDER_BY_ELEMENT = eINSTANCE.getOrderByElement();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ORDER_BY_ELEMENT__OPERATOR = eINSTANCE.getOrderByElement_Operator();

		/**
		 * The meta object literal for the '<em><b>Operand</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ORDER_BY_ELEMENT__OPERAND = eINSTANCE.getOrderByElement_Operand();

		/**
		 * The meta object literal for the '<em><b>Search Query</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ORDER_BY_ELEMENT__SEARCH_QUERY = eINSTANCE.getOrderByElement_SearchQuery();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryResultImpl <em>Query Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.QueryResultImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getQueryResult()
		 * @generated
		 */
		EClass QUERY_RESULT = eINSTANCE.getQueryResult();

		/**
		 * The meta object literal for the '<em><b>Query</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_RESULT__QUERY = eINSTANCE.getQueryResult_Query();

		/**
		 * The meta object literal for the '<em><b>Result Entries</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QUERY_RESULT__RESULT_ENTRIES = eINSTANCE.getQueryResult_ResultEntries();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl <em>Binary Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getBinaryExpression()
		 * @generated
		 */
		EClass BINARY_EXPRESSION = eINSTANCE.getBinaryExpression();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BINARY_EXPRESSION__OPERATOR = eINSTANCE.getBinaryExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Left Operand</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BINARY_EXPRESSION__LEFT_OPERAND = eINSTANCE.getBinaryExpression_LeftOperand();

		/**
		 * The meta object literal for the '<em><b>Right Operands</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BINARY_EXPRESSION__RIGHT_OPERANDS = eINSTANCE.getBinaryExpression_RightOperands();

		/**
		 * The meta object literal for the '<em><b>Case Insensitive</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BINARY_EXPRESSION__CASE_INSENSITIVE = eINSTANCE.getBinaryExpression_CaseInsensitive();

		/**
		 * The meta object literal for the '<em><b>Instance Query</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BINARY_EXPRESSION__INSTANCE_QUERY = eINSTANCE.getBinaryExpression_InstanceQuery();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OperandImpl <em>Operand</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.OperandImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOperand()
		 * @generated
		 */
		EClass OPERAND = eINSTANCE.getOperand();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPERAND__NAME = eINSTANCE.getOperand_Name();

		/**
		 * The meta object literal for the '<em><b>Query</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERAND__QUERY = eINSTANCE.getOperand_Query();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.ResultEntryImpl <em>Result Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ResultEntryImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getResultEntry()
		 * @generated
		 */
		EClass RESULT_ENTRY = eINSTANCE.getResultEntry();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESULT_ENTRY__VALUE = eINSTANCE.getResultEntry_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl <em>Correlation Query</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getCorrelationQuery()
		 * @generated
		 */
		EClass CORRELATION_QUERY = eINSTANCE.getCorrelationQuery();

		/**
		 * The meta object literal for the '<em><b>Correlation Container URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CORRELATION_QUERY__CORRELATION_CONTAINER_URI = eINSTANCE.getCorrelationQuery_CorrelationContainerURI();

		/**
		 * The meta object literal for the '<em><b>Correlation Container Proxy URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CORRELATION_QUERY__CORRELATION_CONTAINER_PROXY_URI = eINSTANCE.getCorrelationQuery_CorrelationContainerProxyURI();

		/**
		 * The meta object literal for the '<em><b>Delta Time</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CORRELATION_QUERY__DELTA_TIME = eINSTANCE.getCorrelationQuery_DeltaTime();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.TimeBasedCorrelationQueryImpl <em>Time Based Correlation Query</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.TimeBasedCorrelationQueryImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getTimeBasedCorrelationQuery()
		 * @generated
		 */
		EClass TIME_BASED_CORRELATION_QUERY = eINSTANCE.getTimeBasedCorrelationQuery();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.LogicalExpressionImpl <em>Logical Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.LogicalExpressionImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getLogicalExpression()
		 * @generated
		 */
		EClass LOGICAL_EXPRESSION = eINSTANCE.getLogicalExpression();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOGICAL_EXPRESSION__OPERATOR = eINSTANCE.getLogicalExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Arguments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOGICAL_EXPRESSION__ARGUMENTS = eINSTANCE.getLogicalExpression_Arguments();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.WhereExpressionImpl <em>Where Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.WhereExpressionImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getWhereExpression()
		 * @generated
		 */
		EClass WHERE_EXPRESSION = eINSTANCE.getWhereExpression();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute WHERE_EXPRESSION__NAME = eINSTANCE.getWhereExpression_Name();

		/**
		 * The meta object literal for the '<em><b>Search Query</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WHERE_EXPRESSION__SEARCH_QUERY = eINSTANCE.getWhereExpression_SearchQuery();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.ArithmeticExpressionImpl <em>Arithmetic Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ArithmeticExpressionImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getArithmeticExpression()
		 * @generated
		 */
		EClass ARITHMETIC_EXPRESSION = eINSTANCE.getArithmeticExpression();

		/**
		 * The meta object literal for the '<em><b>Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ARITHMETIC_EXPRESSION__OPERATOR = eINSTANCE.getArithmeticExpression_Operator();

		/**
		 * The meta object literal for the '<em><b>Arguments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ARITHMETIC_EXPRESSION__ARGUMENTS = eINSTANCE.getArithmeticExpression_Arguments();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.NumericFunctionImpl <em>Numeric Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.NumericFunctionImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getNumericFunction()
		 * @generated
		 */
		EClass NUMERIC_FUNCTION = eINSTANCE.getNumericFunction();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NUMERIC_FUNCTION__FUNCTION = eINSTANCE.getNumericFunction_Function();

		/**
		 * The meta object literal for the '<em><b>Arguments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NUMERIC_FUNCTION__ARGUMENTS = eINSTANCE.getNumericFunction_Arguments();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl <em>Simple Operand</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getSimpleOperand()
		 * @generated
		 */
		EClass SIMPLE_OPERAND = eINSTANCE.getSimpleOperand();

		/**
		 * The meta object literal for the '<em><b>Raw Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SIMPLE_OPERAND__RAW_VALUE = eINSTANCE.getSimpleOperand_RawValue();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SIMPLE_OPERAND__VALUE = eINSTANCE.getSimpleOperand_Value();

		/**
		 * The meta object literal for the '<em><b>Feature</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SIMPLE_OPERAND__FEATURE = eINSTANCE.getSimpleOperand_Feature();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SIMPLE_OPERAND__TYPE = eINSTANCE.getSimpleOperand_Type();

		/**
		 * The meta object literal for the '<em><b>Value Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SIMPLE_OPERAND__VALUE_TYPE = eINSTANCE.getSimpleOperand_ValueType();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators <em>Relational Operators</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getRelationalOperators()
		 * @generated
		 */
		EEnum RELATIONAL_OPERATORS = eINSTANCE.getRelationalOperators();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators <em>Order By Operators</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getOrderByOperators()
		 * @generated
		 */
		EEnum ORDER_BY_OPERATORS = eINSTANCE.getOrderByOperators();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators <em>Logical Operators</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getLogicalOperators()
		 * @generated
		 */
		EEnum LOGICAL_OPERATORS = eINSTANCE.getLogicalOperators();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.ArithmeticOperators <em>Arithmetic Operators</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.ArithmeticOperators
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getArithmeticOperators()
		 * @generated
		 */
		EEnum ARITHMETIC_OPERATORS = eINSTANCE.getArithmeticOperators();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions <em>Numeric Functions</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions
		 * @see org.eclipse.hyades.models.hierarchy.extensions.impl.ExtensionsPackageImpl#getNumericFunctions()
		 * @generated
		 */
		EEnum NUMERIC_FUNCTIONS = eINSTANCE.getNumericFunctions();

	}

} //ExtensionsPackage
