/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: NumericFunction.java,v 1.3 2009/05/05 15:45:27 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Numeric Function</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Function which has only numeric arguments and return types.
 * The value in this case is the value resulted from the evaluation of the function.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunction#getFunction <em>Function</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunction#getArguments <em>Arguments</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getNumericFunction()
 * @model
 * @generated
 */
public interface NumericFunction extends Operand {
	/**
	 * Returns the value of the '<em><b>Function</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Function</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Function</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions
	 * @see #setFunction(NumericFunctions)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getNumericFunction_Function()
	 * @model
	 * @generated
	 */
	NumericFunctions getFunction();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.NumericFunction#getFunction <em>Function</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Function</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions
	 * @see #getFunction()
	 * @generated
	 */
	void setFunction(NumericFunctions value);

	/**
	 * Returns the value of the '<em><b>Arguments</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.extensions.Operand}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Arguments</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Arguments</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getNumericFunction_Arguments()
	 * @model containment="true"
	 * @generated
	 */
	EList<Operand> getArguments();

} // NumericFunction
