/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: OrderByElementImpl.java,v 1.4 2009/05/05 15:45:22 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Order By Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl#getOperator <em>Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl#getOperand <em>Operand</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl#getSearchQuery <em>Search Query</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OrderByElementImpl extends EObjectImpl implements OrderByElement {
	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final OrderByOperators OPERATOR_EDEFAULT = OrderByOperators.ASC_LITERAL;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected OrderByOperators operator = OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOperand() <em>Operand</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperand()
	 * @generated
	 * @ordered
	 */
	protected Operand operand;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderByElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExtensionsPackage.Literals.ORDER_BY_ELEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrderByOperators getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(OrderByOperators newOperator) {
		OrderByOperators oldOperator = operator;
		operator = newOperator == null ? OPERATOR_EDEFAULT : newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operand getOperand() {
		return operand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOperand(Operand newOperand, NotificationChain msgs) {
		Operand oldOperand = operand;
		operand = newOperand;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, oldOperand, newOperand);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperand(Operand newOperand) {
		if (newOperand != operand) {
			NotificationChain msgs = null;
			if (operand != null)
				msgs = ((InternalEObject)operand).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, null, msgs);
			if (newOperand != null)
				msgs = ((InternalEObject)newOperand).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, null, msgs);
			msgs = basicSetOperand(newOperand, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, newOperand, newOperand));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleSearchQuery getSearchQuery() {
		if (eContainerFeatureID() != ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY) return null;
		return (SimpleSearchQuery)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSearchQuery(SimpleSearchQuery newSearchQuery, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSearchQuery, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSearchQuery(SimpleSearchQuery newSearchQuery) {
		if (newSearchQuery != eInternalContainer() || (eContainerFeatureID() != ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY && newSearchQuery != null)) {
			if (EcoreUtil.isAncestor(this, newSearchQuery))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSearchQuery != null)
				msgs = ((InternalEObject)newSearchQuery).eInverseAdd(this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS, SimpleSearchQuery.class, msgs);
			msgs = basicSetSearchQuery(newSearchQuery, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY, newSearchQuery, newSearchQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSearchQuery((SimpleSearchQuery)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				return basicSetOperand(null, msgs);
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				return basicSetSearchQuery(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				return eInternalContainer().eInverseRemove(this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS, SimpleSearchQuery.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				return getOperator();
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				return getOperand();
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				return getSearchQuery();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				setOperator((OrderByOperators)newValue);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				setOperand((Operand)newValue);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				setOperand((Operand)null);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				return operator != OPERATOR_EDEFAULT;
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				return operand != null;
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				return getSearchQuery() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operator: ");
		result.append(operator);
		result.append(')');
		return result.toString();
	}

} //OrderByElementImpl
