/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CorrelationContainerProxyImpl.java,v 1.4 2009/05/05 15:45:26 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Container Proxy</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCorrelationContainer <em>Correlation Container</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCorrelatedAgents <em>Correlated Agents</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCorrelationEngine <em>Correlation Engine</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getMonitor <em>Monitor</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CorrelationContainerProxyImpl extends EObjectImpl implements CorrelationContainerProxy {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreationTime()
	 * @generated
	 * @ordered
	 */
	protected static final long CREATION_TIME_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreationTime()
	 * @generated
	 * @ordered
	 */
	protected long creationTime = CREATION_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCorrelationContainer() <em>Correlation Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainer()
	 * @generated
	 * @ordered
	 */
	protected CorrelationContainer correlationContainer;

	/**
	 * The cached value of the '{@link #getCorrelatedAgents() <em>Correlated Agents</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelatedAgents()
	 * @generated
	 * @ordered
	 */
	protected EList<TRCAgentProxy> correlatedAgents;

	/**
	 * The cached value of the '{@link #getCorrelationEngine() <em>Correlation Engine</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationEngine()
	 * @generated
	 * @ordered
	 */
	protected CorrelationEngine correlationEngine;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationContainerProxyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HierarchyPackage.Literals.CORRELATION_CONTAINER_PROXY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getCreationTime() {
		return creationTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCreationTime(long newCreationTime) {
		long oldCreationTime = creationTime;
		creationTime = newCreationTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME, oldCreationTime, creationTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainer getCorrelationContainer() {
		if (correlationContainer != null && correlationContainer.eIsProxy()) {
			InternalEObject oldCorrelationContainer = (InternalEObject)correlationContainer;
			correlationContainer = (CorrelationContainer)eResolveProxy(oldCorrelationContainer);
			if (correlationContainer != oldCorrelationContainer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER, oldCorrelationContainer, correlationContainer));
			}
		}
		return correlationContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainer basicGetCorrelationContainer() {
		return correlationContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationContainer(CorrelationContainer newCorrelationContainer, NotificationChain msgs) {
		CorrelationContainer oldCorrelationContainer = correlationContainer;
		correlationContainer = newCorrelationContainer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER, oldCorrelationContainer, newCorrelationContainer);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCorrelationContainer(CorrelationContainer newCorrelationContainer) {
		if (newCorrelationContainer != correlationContainer) {
			NotificationChain msgs = null;
			if (correlationContainer != null)
				msgs = ((InternalEObject)correlationContainer).eInverseRemove(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATION_CONTAINER_PROXY, CorrelationContainer.class, msgs);
			if (newCorrelationContainer != null)
				msgs = ((InternalEObject)newCorrelationContainer).eInverseAdd(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATION_CONTAINER_PROXY, CorrelationContainer.class, msgs);
			msgs = basicSetCorrelationContainer(newCorrelationContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER, newCorrelationContainer, newCorrelationContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TRCAgentProxy> getCorrelatedAgents() {
		if (correlatedAgents == null) {
			correlatedAgents = new EObjectResolvingEList<TRCAgentProxy>(TRCAgentProxy.class, this, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS);
		}
		return correlatedAgents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationEngine getCorrelationEngine() {
		return correlationEngine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationEngine(CorrelationEngine newCorrelationEngine, NotificationChain msgs) {
		CorrelationEngine oldCorrelationEngine = correlationEngine;
		correlationEngine = newCorrelationEngine;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE, oldCorrelationEngine, newCorrelationEngine);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setCorrelationEngine(CorrelationEngine newCorrelationEngine) {
		if (newCorrelationEngine != correlationEngine) {
			NotificationChain msgs = null;
			if (correlationEngine != null)
				msgs = ((InternalEObject) correlationEngine).eInverseRemove(this, HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY, CorrelationEngine.class, msgs);
			if (newCorrelationEngine != null)
				msgs = ((InternalEObject) newCorrelationEngine).eInverseAdd(this, HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY, CorrelationEngine.class, msgs);
			msgs = basicSetCorrelationEngine(newCorrelationEngine, msgs);
			if (msgs != null)
				msgs.dispatch();
			if ((name == null || name == LoadersUtils.InternalCorrelationName) && newCorrelationEngine != null && newCorrelationEngine.getName() != null) {
				setName(LoadersUtils.getInternalCorrelationName(newCorrelationEngine.getName()));
			}

		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE, newCorrelationEngine, newCorrelationEngine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMonitor getMonitor() {
		if (eContainerFeatureID() != HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR) return null;
		return (TRCMonitor)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMonitor(TRCMonitor newMonitor, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newMonitor, HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMonitor(TRCMonitor newMonitor) {
		if (newMonitor != eInternalContainer() || (eContainerFeatureID() != HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR && newMonitor != null)) {
			if (EcoreUtil.isAncestor(this, newMonitor))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newMonitor != null)
				msgs = ((InternalEObject)newMonitor).eInverseAdd(this, HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES, TRCMonitor.class, msgs);
			msgs = basicSetMonitor(newMonitor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR, newMonitor, newMonitor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				if (correlationContainer != null)
					msgs = ((InternalEObject)correlationContainer).eInverseRemove(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATION_CONTAINER_PROXY, CorrelationContainer.class, msgs);
				return basicSetCorrelationContainer((CorrelationContainer)otherEnd, msgs);
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				if (correlationEngine != null)
					msgs = ((InternalEObject)correlationEngine).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE, null, msgs);
				return basicSetCorrelationEngine((CorrelationEngine)otherEnd, msgs);
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetMonitor((TRCMonitor)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				return basicSetCorrelationContainer(null, msgs);
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				return basicSetCorrelationEngine(null, msgs);
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				return basicSetMonitor(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				return eInternalContainer().eInverseRemove(this, HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES, TRCMonitor.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				return getName();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				return getCreationTime();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				if (resolve) return getCorrelationContainer();
				return basicGetCorrelationContainer();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				return getCorrelatedAgents();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				return getCorrelationEngine();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				return getMonitor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				setCreationTime((Long)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				setCorrelationContainer((CorrelationContainer)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				getCorrelatedAgents().clear();
				getCorrelatedAgents().addAll((Collection<? extends TRCAgentProxy>)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				setCorrelationEngine((CorrelationEngine)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				setMonitor((TRCMonitor)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				setCreationTime(CREATION_TIME_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				setCorrelationContainer((CorrelationContainer)null);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				getCorrelatedAgents().clear();
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				setCorrelationEngine((CorrelationEngine)null);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				setMonitor((TRCMonitor)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				return creationTime != CREATION_TIME_EDEFAULT;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				return correlationContainer != null;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				return correlatedAgents != null && !correlatedAgents.isEmpty();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				return correlationEngine != null;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				return getMonitor() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", creationTime: ");
		result.append(creationTime);
		result.append(')');
		return result.toString();
	}

} //CorrelationContainerProxyImpl
