/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CorrelationEngineImpl.java,v 1.3 2009/05/05 15:45:26 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Engine</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl#getCorrelationContainerProxy <em>Correlation Container Proxy</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CorrelationEngineImpl extends EObjectImpl implements CorrelationEngine {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationEngineImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HierarchyPackage.Literals.CORRELATION_ENGINE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_ENGINE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_ENGINE__NAME, oldName, name));
		if (getCorrelationContainerProxy() != null
				&& (getCorrelationContainerProxy().getName() == null || getCorrelationContainerProxy().getName() == LoadersUtils.InternalCorrelationName)) {
			getCorrelationContainerProxy().setName(LoadersUtils.getInternalCorrelationName(name));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_ENGINE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_ENGINE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainerProxy getCorrelationContainerProxy() {
		if (eContainerFeatureID() != HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY) return null;
		return (CorrelationContainerProxy)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationContainerProxy(CorrelationContainerProxy newCorrelationContainerProxy, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newCorrelationContainerProxy, HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setCorrelationContainerProxy(CorrelationContainerProxy newCorrelationContainerProxy) {
		if (newCorrelationContainerProxy != eContainer
				|| (eContainerFeatureID() != HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY && newCorrelationContainerProxy != null)) {
			if (EcoreUtil.isAncestor(this, newCorrelationContainerProxy))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newCorrelationContainerProxy != null)
				msgs = ((InternalEObject) newCorrelationContainerProxy).eInverseAdd(this, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE,
						CorrelationContainerProxy.class, msgs);
			msgs = eBasicSetContainer((InternalEObject) newCorrelationContainerProxy, HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY, msgs);
			if (msgs != null)
				msgs.dispatch();
			if (name != null && newCorrelationContainerProxy != null
					&& (newCorrelationContainerProxy.getName() == null || newCorrelationContainerProxy.getName() == LoadersUtils.InternalCorrelationName)) {
				newCorrelationContainerProxy.setName(LoadersUtils.getInternalCorrelationName(name));
			}

		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY, newCorrelationContainerProxy,
					newCorrelationContainerProxy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetCorrelationContainerProxy((CorrelationContainerProxy)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY:
				return basicSetCorrelationContainerProxy(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY:
				return eInternalContainer().eInverseRemove(this, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE, CorrelationContainerProxy.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENGINE__TYPE:
				return getType();
			case HierarchyPackage.CORRELATION_ENGINE__NAME:
				return getName();
			case HierarchyPackage.CORRELATION_ENGINE__ID:
				return getId();
			case HierarchyPackage.CORRELATION_ENGINE__DESCRIPTION:
				return getDescription();
			case HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY:
				return getCorrelationContainerProxy();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENGINE__TYPE:
				setType((String)newValue);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__ID:
				setId((String)newValue);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY:
				setCorrelationContainerProxy((CorrelationContainerProxy)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENGINE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__ID:
				setId(ID_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY:
				setCorrelationContainerProxy((CorrelationContainerProxy)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_ENGINE__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case HierarchyPackage.CORRELATION_ENGINE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.CORRELATION_ENGINE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case HierarchyPackage.CORRELATION_ENGINE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY:
				return getCorrelationContainerProxy() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", name: ");
		result.append(name);
		result.append(", id: ");
		result.append(id);
		result.append(", description: ");
		result.append(description);
		result.append(')');
		return result.toString();
	}

} //CorrelationEngineImpl
