/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CorrelationSourceInfoImpl.java,v 1.4 2009/05/05 15:45:26 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Source Info</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl#getOwner <em>Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl#getReference <em>Reference</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl#getTargetInfo <em>Target Info</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CorrelationSourceInfoImpl extends EObjectImpl implements CorrelationSourceInfo {
	/**
	 * The cached value of the '{@link #getOwner() <em>Owner</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwner()
	 * @generated
	 * @ordered
	 */
	protected EObject owner;

	/**
	 * The cached value of the '{@link #getReference() <em>Reference</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReference()
	 * @generated
	 * @ordered
	 */
	protected EReference reference;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationSourceInfoImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HierarchyPackage.Literals.CORRELATION_SOURCE_INFO;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getOwner() {
		if (owner != null && owner.eIsProxy()) {
			InternalEObject oldOwner = (InternalEObject)owner;
			owner = eResolveProxy(oldOwner);
			if (owner != oldOwner) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER, oldOwner, owner));
			}
		}
		return owner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject basicGetOwner() {
		return owner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwner(EObject newOwner) {
		EObject oldOwner = owner;
		owner = newOwner;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER, oldOwner, owner));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getReference() {
		if (reference != null && reference.eIsProxy()) {
			InternalEObject oldReference = (InternalEObject)reference;
			reference = (EReference)eResolveProxy(oldReference);
			if (reference != oldReference) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE, oldReference, reference));
			}
		}
		return reference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference basicGetReference() {
		return reference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReference(EReference newReference) {
		EReference oldReference = reference;
		reference = newReference;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE, oldReference, reference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnresolvedCorrelation getTargetInfo() {
		if (eContainerFeatureID() != HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO) return null;
		return (UnresolvedCorrelation)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTargetInfo(UnresolvedCorrelation newTargetInfo, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newTargetInfo, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTargetInfo(UnresolvedCorrelation newTargetInfo) {
		if (newTargetInfo != eInternalContainer() || (eContainerFeatureID() != HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO && newTargetInfo != null)) {
			if (EcoreUtil.isAncestor(this, newTargetInfo))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTargetInfo != null)
				msgs = ((InternalEObject)newTargetInfo).eInverseAdd(this, HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS, UnresolvedCorrelation.class, msgs);
			msgs = basicSetTargetInfo(newTargetInfo, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO, newTargetInfo, newTargetInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetTargetInfo((UnresolvedCorrelation)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				return basicSetTargetInfo(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				return eInternalContainer().eInverseRemove(this, HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS, UnresolvedCorrelation.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				if (resolve) return getOwner();
				return basicGetOwner();
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				if (resolve) return getReference();
				return basicGetReference();
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				return getTargetInfo();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				setOwner((EObject)newValue);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				setReference((EReference)newValue);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				setTargetInfo((UnresolvedCorrelation)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				setOwner((EObject)null);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				setReference((EReference)null);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				setTargetInfo((UnresolvedCorrelation)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				return owner != null;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				return reference != null;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				return getTargetInfo() != null;
		}
		return super.eIsSet(featureID);
	}

} //CorrelationSourceInfoImpl
