/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: UnresolvedCorrelationImpl.java,v 1.4 2009/05/05 15:45:26 paules Exp $
 **********************************************************************/

/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Unresolved Correlation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl#getContextId <em>Context Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl#getAgent <em>Agent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl#getSourceInfos <em>Source Infos</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class UnresolvedCorrelationImpl extends EObjectImpl implements UnresolvedCorrelation {
	/**
	 * The default value of the '{@link #getContextId() <em>Context Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextId()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTEXT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContextId() <em>Context Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextId()
	 * @generated
	 * @ordered
	 */
	protected String contextId = CONTEXT_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSourceInfos() <em>Source Infos</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfos()
	 * @generated
	 * @ordered
	 */
	protected EList<CorrelationSourceInfo> sourceInfos;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedCorrelationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HierarchyPackage.Literals.UNRESOLVED_CORRELATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContextId() {
		return contextId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContextId(String newContextId) {
		String oldContextId = contextId;
		contextId = newContextId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID, oldContextId, contextId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgent getAgent() {
		if (eContainerFeatureID() != HierarchyPackage.UNRESOLVED_CORRELATION__AGENT) return null;
		return (TRCAgent)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAgent(TRCAgent newAgent, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newAgent, HierarchyPackage.UNRESOLVED_CORRELATION__AGENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAgent(TRCAgent newAgent) {
		if (newAgent != eInternalContainer() || (eContainerFeatureID() != HierarchyPackage.UNRESOLVED_CORRELATION__AGENT && newAgent != null)) {
			if (EcoreUtil.isAncestor(this, newAgent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newAgent != null)
				msgs = ((InternalEObject)newAgent).eInverseAdd(this, HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS, TRCAgent.class, msgs);
			msgs = basicSetAgent(newAgent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.UNRESOLVED_CORRELATION__AGENT, newAgent, newAgent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CorrelationSourceInfo> getSourceInfos() {
		if (sourceInfos == null) {
			sourceInfos = new EObjectContainmentWithInverseEList<CorrelationSourceInfo>(CorrelationSourceInfo.class, this, HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO);
		}
		return sourceInfos;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetAgent((TRCAgent)otherEnd, msgs);
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSourceInfos()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				return basicSetAgent(null, msgs);
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				return ((InternalEList<?>)getSourceInfos()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				return eInternalContainer().eInverseRemove(this, HierarchyPackage.TRC_AGENT__UNRESOLVED_CORRELATIONS, TRCAgent.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				return getContextId();
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				return getAgent();
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				return getSourceInfos();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				setContextId((String)newValue);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				getSourceInfos().clear();
				getSourceInfos().addAll((Collection<? extends CorrelationSourceInfo>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				setContextId(CONTEXT_ID_EDEFAULT);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				setAgent((TRCAgent)null);
				return;
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				getSourceInfos().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HierarchyPackage.UNRESOLVED_CORRELATION__CONTEXT_ID:
				return CONTEXT_ID_EDEFAULT == null ? contextId != null : !CONTEXT_ID_EDEFAULT.equals(contextId);
			case HierarchyPackage.UNRESOLVED_CORRELATION__AGENT:
				return getAgent() != null;
			case HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS:
				return sourceInfos != null && !sourceInfos.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (contextId: ");
		result.append(contextId);
		result.append(')');
		return result.toString();
	}

} //UnresolvedCorrelationImpl
