/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CompoundIterator.java,v 1.2 2007/12/01 00:06:21 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/**
 * @author Marius Slavescu (slavescu@ca.ibm.com)
 * @since 3.3
 * 
 */
public class CompoundIterator implements Iterator {
	int currentProvider;

	int currentPosition;

	List elementProviders = new FastList();

	public void addIterator(Iterator iterator) {
		elementProviders.add(iterator);
	}

	public void addList(List list) {
		elementProviders.add(list);
	}

	public void addObject(Object object) {
		elementProviders.add(object);
	}

	public void clear() {
		currentProvider = 0;
		currentPosition=0;
		elementProviders.clear();
	}

	public boolean hasNext() {
		if (elementProviders.size() > currentProvider) {
			Object provider  = elementProviders.get(currentProvider);
			if (provider instanceof List) {
				return currentPosition < ((List) provider).size();
			} else if (provider instanceof Iterator) {
				return ((Iterator) provider).hasNext();
			} else
				return true;
		}
		return false;
	}

	public Object next() {
		if (elementProviders.size() > currentProvider) {
			Object provider = elementProviders.get(currentProvider);
			if (provider instanceof List) {
				Object res = ((List) provider).get(currentPosition++);
				if (currentPosition == ((List) provider).size()) {
					nextProvider();
				}
				return res;
			} else if (provider instanceof Iterator) {
				Object res = ((Iterator) provider).next();
				if (!((Iterator) provider).hasNext()) {
					nextProvider();
				}
				return res;
			} else {
				return elementProviders.get(currentProvider++);
			}
		} else
			throw new NoSuchElementException();
	}

	public void remove() {
		if (elementProviders.size() > currentProvider) {
			Object provider = elementProviders.get(currentProvider);
			if (provider instanceof List) {
				((List) provider).remove(currentPosition);
				if (currentPosition == ((List) provider).size()) {
					nextProvider();
				}
			} else if (provider instanceof Iterator) {
				((Iterator) provider).remove();
				if (!((Iterator) provider).hasNext()) {
					nextProvider();
				}
			} else {
				elementProviders.remove(currentProvider - 1);
			}
		} else
			throw new NoSuchElementException();
	}

	protected void nextProvider() {
		currentProvider++;
		currentPosition = 0;
	}
}