/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HierarchyResourceFactoryImpl.java,v 1.3 2009/10/19 15:54:37 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/**
 * HierarchyResourceFactoryImpl.java
 * 
 * 
 * @author  Paul Slauenwhite
 * @author  Alex Nan
 * @version October 19, 2009
 * @since   November 27, 2007
 */
public class HierarchyResourceFactoryImpl extends XMIResourceFactoryImpl {
    //~ Constructors -------------------------------------------------------------------------------

    public HierarchyResourceFactoryImpl() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public Resource createResource(URI uri) {
        HierarchyXMIResourceImpl r = new HierarchyXMIResourceImpl(uri);

        r.setUseZip(true);
        r.setEncoding("UTF-8");
		r.getDefaultLoadOptions().put(XMLResource.OPTION_RECORD_UNKNOWN_FEATURE,Boolean.TRUE);
//		r.getDefaultLoadOptions().put(XMLResource.OPTION_USE_DEPRECATED_METHODS,Boolean.FALSE);
		r.getDefaultLoadOptions().put(XMLResource.OPTION_DEFER_ATTACHMENT,Boolean.TRUE);
		r.getDefaultLoadOptions().put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION,Boolean.TRUE);

		//Defect 215784: Removed the OPTION_USE_FILE_BUFFER option since it creates a temporary 
		//file in org.eclipse.emf.ecore.xmi.impl.XMLString when created by 
		//org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl.init(XMLResource, Map).  However, 
		//org.eclipse.hyades.models.hierarchy.util.HierarchyXMLString overrides 
		//org.eclipse.emf.ecore.xmi.impl.XMLString and does not require/handle the 
		//temporary file.
		//r.getDefaultSaveOptions().put(XMLResource.OPTION_USE_FILE_BUFFER, Boolean.TRUE);
		
		r.getDefaultSaveOptions().put(XMLResource.OPTION_FLUSH_THRESHOLD, new Integer(org.eclipse.hyades.models.hierarchy.util.HierarchyXMISaveImpl.BUFFER_SIZE));
		r.getDefaultSaveOptions().put(XMLResource.OPTION_FORMATTED, Boolean.FALSE);

        return r;
    }
}
