/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HierarchyXMLString.java,v 1.4 2009/10/19 16:01:36 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.hyades.models.util.ModelDebugger;

/**
 * <p>Calling sequence is:</p>
 * 
 * <p>Empty Element:</p>
 * 
 * <ol>
 * 	<li>startElement()</li> 
 * 	<li>addAttrribute()*
 * 		<ol>
 * 			<li>startAttribute()</li>
 * 			<li>addAttributeContent()</li>
 * 			<li>endAttribute()</li>
 *  	</ol>
 *  </li>
 *  <li>endEmptyElement()</li> 
 * 	<li>endElement()</li>
 * </ol>
 * 
 * <p>Child Element(s):</p>
 * 
 * <ol>
 * 	<li>startElement()</li> 
 * 	<li>addAttrribute()*
 * 		<ol>
 * 			<li>startAttribute()</li>
 * 			<li>addAttributeContent()</li>
 * 			<li>endAttribute()</li>
 *  	</ol>
 *  </li>
 *  <li>endContentElement()</li> 
 *  <ol>
 *  	<li>startElement()*</li>
 *  	<li>...</li>  
 * 		<li>endElement()*</li>
 *  </ol>
 * 	<li>endElement()</li>
 * </ol>

 * <p>*0 or more times</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @author  Alex Nan
 * @version October 19, 2009
 * @since   November 27, 2007
 */
public class HierarchyXMLString extends XMLString {
	/**
	 * 
	 */
	protected static final long serialVersionUID = 3905523791567599922L;
	//	protected static int BUFFER_SIZE = 1024 * 256;
	//    //~ Instance fields
	// ----------------------------------------------------------------------------
	//	protected char [] buffer = new char[BUFFER_SIZE];
	//	protected int currentPos = 0;
	//    protected List elementNames;
	//    protected List indents;
	protected static final String SPACE = " ";
	protected Writer writer = null;
	//    protected boolean lastElementIsStart;
	//    protected int currentLineWidth;
	//    protected int lineWidth;
	//    protected int markedLineWidth;

	//~ Constructors
	// -------------------------------------------------------------------------------

	public HierarchyXMLString(OutputStreamWriter outputStreamWriter) {
		super(80);
		this.writer = outputStreamWriter;
		elementNames = new BasicEList();
		indents = new org.eclipse.emf.common.util.BasicEList();
		indents.add("");
	}

	//~ Methods
	// ------------------------------------------------------------------------------------

	public void setWriter(Writer outputStreamWriter) {
		this.writer = outputStreamWriter;
	}

	public Writer getWriter() {
		return writer;
	}

	public void addAttribute(String name, String value) {
		try {
			writer.write(" ".concat(name).concat("=\"").concat(value).concat("\""));
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	public void addAttributeNS(String prefix, String localName, String value) {
		addAttribute((prefix.concat(":").concat(localName)), value);
	}

	public void addAttributeContent(String content) {
		try {
			writer.write(content);
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	public void endAttribute() {
		try {
			writer.write('"');
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	public void endContentElement(String content) {
		try {
			
			writer.write(">".concat(content).concat("</").concat(removeLast()).concat(">").concat(lineSeparator));
			
			lastElementIsStart = false;
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	public void endElement() {
		if (lastElementIsStart) {
			endEmptyElement();
		} else {
			try {
				
				writer.write(getElementIndent().concat("</").concat(removeLast()).concat(">").concat(lineSeparator));
				
				lastElementIsStart = false;
			} catch (IOException e) {
				ModelDebugger.log(e);
			}
		}
	}

	public void endEmptyElement() {
		try {

			removeLast();
			
			writer.write("/>".concat(lineSeparator));
			
			lastElementIsStart = false;
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	/**
	 * Method iterator.
	 */
	public Iterator iterator() {
		return null;
	}

	public Object mark() {
		return null;
	}

	public void resetToMark(Object mark) {
		//do nothing
	}

	public void startAttribute(String name) {
		try {
			writer.write(" ".concat(name).concat("=\""));
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	public void startElement(String name) {
		try {
			if (lastElementIsStart) {
				closeStartElement();
			}

			elementNames.add(name);
			
			writer.write(getElementIndent().concat("<").concat(name));
			
			lastElementIsStart = true;
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	protected String getAttributeIndent() {
		//        int depth = elementNames.size() + 1;
		//
		//        for (int i = indents.size() - 1; i < depth; ++i) {
		//            indents.add(indents.get(i) + " ");
		//        }

		//        return (String) indents.get(depth);
		return SPACE;
	}

	protected String getElementIndent() {
		//        int depth = elementNames.size() - 1;
		//
		//        for (int i = indents.size() - 1; i < depth; ++i) {
		//            indents.add(indents.get(i) + " ");
		//        }
		//
		//        return (String) indents.get(depth);
		return SPACE;
	}

	protected void closeStartElement() {
		try {
			writer.write(">".concat(lineSeparator));
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	protected String removeLast() {
		int end = elementNames.size();

		return (String) elementNames.remove(end - 1);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.xmi.impl.StringSegment#add(java.lang.String)
	 */
	public void add(String newString) {
		try {
			writer.write(newString);
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.xmi.impl.StringSegment#addLine()
	 */
	public void addLine() {
		try {
			writer.write(lineSeparator);
		} catch (IOException e) {
			ModelDebugger.log(e);
		}
	}

}
