/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesExtendedResourceFactory.java,v 1.1 2007/11/27 04:28:31 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.util.ModelDebugger;


public class HyadesExtendedResourceFactory extends ResourceFactoryImpl {
    //~ Constructors -------------------------------------------------------------------------------

    public  HyadesExtendedResourceFactory() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public Resource createResource(URI uri) {
    	List notLoaded = new ArrayList();
//    	notLoaded.add(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
//    	notLoaded.add(HierarchyPackage.eINSTANCE.getAbstractDefaultEvent());
    	notLoaded.add(HierarchyPackage.eINSTANCE.getTRCAgentProxy());
		Properties p = getPropertiesFromURI(uri);
		if(p!=null)
	    	return HyadesResourceExtensions.getInstance().createResource(uri,p,notLoaded);
		else
		{
			String storeType = ((IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri.toString()))).getStoreType(LoadersUtils.getPostfix(uri.toString()));
			p = (Properties)HyadesResourceExtensions.getInstance().getProperties(storeType);
			if(p==null)
				p = (Properties)HyadesResourceExtensions.getInstance().getProperties();
			savePropertiesToURI(uri,p);
			return HyadesResourceExtensions.getInstance().createResource(uri,p,notLoaded);
		}
    }

	public static Properties getPropertiesFromURI(URI uri) {
		HierarchyURIConverterImpl c = new HierarchyURIConverterImpl();
		try {
			InputStream s = c.createInputStream(uri);
			Properties p = new Properties();
			p.load(s);
			String pass = (String)p.getProperty("password");
			if(pass!=null && pass.length()>0)
			{
				pass = LoadersUtils.restorePassword(pass);
				p.setProperty("password",pass);
			}
			s.close();
			return p;
		} catch (IOException e) {
			if(ModelDebugger.INSTANCE.debug)
				ModelDebugger.log(e);
		}
		return null;
	}
	public static void savePropertiesToURI(URI uri,Properties p) {
		HierarchyURIConverterImpl c = new HierarchyURIConverterImpl();
		try {
			OutputStream s = c.createOutputStream(uri);
			String pass = (String)p.getProperty("password");
			if(pass!=null && pass.length()>0)
			{
				String e_pass = LoadersUtils.scramblePassword(pass);
				p.setProperty("password",e_pass);
			}
			
			p.store(s,"DBInfo");
			if(pass!=null && pass.length()>0)
				p.setProperty("password",pass);
			s.close();
		} catch (IOException e) {
			if(ModelDebugger.INSTANCE.debug)
				ModelDebugger.log(e);
		}
	}
}
