/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IHyadesResourceExtension.java,v 1.2 2007/12/01 00:06:21 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.hierarchy.util;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.loaders.util.IPagingListFactory;
import org.eclipse.hyades.loaders.util.IPagingMapFactory;

/**
 * @author slavescu
 */
public interface IHyadesResourceExtension extends IExtendedQueryService,IPagingListFactory, IPagingMapFactory{
	String LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE = "largeResourceSupportCurrentDBType";
	String LRSP_LOCATION = "largeResourceSupportLocation";
	String LRSP_USERNAME = "largeResourceSupportUsername";
	String LRSP_PASSWORD = "largeResourceSupportPassword";
	String LRSP_CACHE_SIZE = "largeResourceSupportCacheSize";
	
	String getStoreType(String postfix);
	//returns list of Strings - URI postfixes
	List getSupportedPostfixes();
	IHyadesExtendedResource createResource(URI uri, Properties properties);
	IHyadesExtendedResource createResource(URI uri, Properties properties,Collection notLoaded);

	//returns the types associated to the jdbc diver provided in the argument
	List getStoreTypeNames(File file);
	
	// creates the underlining DB tables
	boolean createTables(String storeType,Properties properties);
	// drops the underlining DB tables
	boolean dropTables(String storeType,Properties properties);
}
