/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILogFilterCriteria.java,v 1.2 2007/12/01 00:06:21 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Map;


public interface ILogFilterCriteria {

	public static final String OPTION_ONLY_CORRELATED = "correlated"; //option used to set a filter to show only correlated events
	public static final String OPTION_ONLY_ANALYZED = "analyzed"; //option used to set a filter to show only analyzed events
	public static final String OPTION_ONLY_MATCHED = "matched"; //option used to set a filter to show analyzed events that have matches
	public static final String OPTION_FILTER_SEV1 = "sev1"; //option used to set a filter to show high severity events
	public static final String OPTION_FILTER_SEV2 = "sev2"; //option used to set a filter to show medium severity events
	public static final String OPTION_FILTER_SEV3 = "sev3"; //option used to set a filter to show low severity events
	
	/**
	 * Determines if the filter criteria was changed.
	 * 
	 * @return
	 */
	public boolean isDirty();
	
	/**
	 * Gets the list of filters that represents the criteria.
	 * 
	 * @return
	 */
	public IFilterElement[] getFilters();

	/**
	 * Sets the filters that represents the criteria.
	 * @param list
	 */
	public void setFilters(IFilterElement[] list);

	/**
	 * Returns the filter options map that where set for the filter criteria.
	 * @return
	 */
	public Map getFilterOptions();

	/**
	 * Sets filter options (for ex. to show only correlated events, to show only analyzed events etc.)
	 * @param options the options map created using the constants declared in this interface.
	 */
	public void setFilterOptions(Map options);
	
	/**
	 * Returns an array of sorting columns for this filter.
	 * @return
	 */
	
	public ISortElement[] getSortColumns();
	
	/**
	 * Sets the sorting columns for this filter.
	 * @return
	 */	
	public void setSortColumns(ISortElement[] columns);
}
