/*******************************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PerfUtil.java,v 1.2 2008/01/24 02:28:17 apnan Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.models.hierarchy.util;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.hyades.models.util.ModelDebugger;
public class PerfUtil {
	/**
	 * @deprecated use {@link #createInstance()}
	 */
	public PerfUtil() {
		super();
		setDebugFlag();
	}
	
	protected long startTime, stopTime;
	protected long startTotMem, startFreeMem, stopTotMem, stopFreeMem;
	protected String msg;
	protected boolean debug=false;
	protected static Map registry = new HashMap();
	protected static PerfUtil staticInactiveInstance = new PerfUtil("PerfUtil- disabled",false);
	/**
	 * @deprecated use {@link #createInstance(String, boolean)}
	 */
	public PerfUtil(String msg,boolean start) {
		setDebugFlag();
		if(!debug)
			return;
		this.msg = msg;
		if(start)
			start();
	}
	
	public static PerfUtil createInstance(String msg,boolean start)
	{
		if(ModelDebugger.INSTANCE.debugPerfUtil)
		{
			return new PerfUtil(msg,start);
		}
		else
			return staticInactiveInstance;
	}
	public static PerfUtil createInstance()
	{
		if(ModelDebugger.INSTANCE.debugPerfUtil)
		{
			return new PerfUtil();
		}
		else
			return staticInactiveInstance;
	}
	/**
	 * 
	 */
	protected void setDebugFlag() {
		try {
			 String s = System.getProperties().getProperty("ModelDebugger.debugPerfUtil"); // use -DModelDebugger.debugPerfUtil=true on VMARGS to enable the probes
			 if(Boolean.valueOf(s).booleanValue())
			 {
			 	debug=true;
			 }
			 if(!debug)
				debug = ModelDebugger.INSTANCE.debugPerfUtil;
		} catch (Exception e) {
			//ignore and let debug on default
		}
	}
	public void start() {
		if(!debug)
			return;
		startTime = System.currentTimeMillis();
		stopTime = startTime;
		//		  Runtime.getRuntime().gc();
		startTotMem = Runtime.getRuntime().totalMemory();
		startFreeMem = Runtime.getRuntime().freeMemory();
	}
	public void stop() {
		if(!debug)
			return;
		stopTime = System.currentTimeMillis();
		//	      Runtime.getRuntime().gc();
		stopTotMem = Runtime.getRuntime().totalMemory();
		stopFreeMem = Runtime.getRuntime().freeMemory();
	}
	public long getTime() {
		return stopTime - startTime;
	}
	public void printStatus() {
		printStatus(System.out);
	}
	public void printStatus(String m) {
		if(!debug)
			return;
		this.msg+=", "+m;
		printStatus(System.out);
	}
	public void printStatus(PrintStream out) {
		if(debug)
		{
			out.println(msg + ": deltaTime=" + getTime() + " - stopTime=" + stopTime + " - usedMemoryDelta=" + getUsedMemoryDelta() +" - freeMemoryDelta=" + getFreeMemoryDelta()+ " - totalMemoryDelta=" + getTotalMemoryDelta() + " - usedMemoryAfter=" + (stopTotMem-stopFreeMem)+ " - freeMemoryAfter=" + stopFreeMem +" - totalMemoryAfter=" + stopTotMem);
			ModelDebugger.logCallstackWithLimit(new Throwable("PerfUtil"),ModelDebugger.INSTANCE.exceptionDepth,out);
		}
	}
	/**
	 * @return
	 */
	public long getUsedMemoryDelta() {
		return (stopTotMem-stopFreeMem)-(startTotMem-startFreeMem);
	}
	/**
	 * @return
	 */
	public long getTotalMemoryDelta() {
		return stopTotMem - startTotMem;
	}
	public long getFreeMemoryDelta() {
		return stopFreeMem - startFreeMem;
	}
	
	public long getUsedMemoryAfter(){
		return stopTotMem-stopFreeMem;		
	}
	
	public long getFreeMemoryAfter(){
		return stopFreeMem;
	}
	
	public long getTotalMemoryAfter(){
		return stopTotMem;
	}
	/**
	 * @param string
	 */
	public void setMessage(String msg) {
		if(!debug)
			return;
		this.msg= msg;
	}
	/**
	 * @return Returns the msg.
	 */
	public String getMessage() {
		return msg;
	}
	/**
	 * @param string
	 */
	public PerfUtil setMessageAndStart(String string) {
		if(!debug)
			return this;
		setMessage(string);
		start();
		return this;
	}
	public PerfUtil stopAndPrintStatus() {
		if(!debug)
			return this;
		stop();
		printStatus();
		return this;
	}
	public PerfUtil stopAndPrintStatus(String msg) {
		if(!debug)
			return this;
		this.msg+=", "+msg;
		stop();
		printStatus();
		return this;
	}
	
	public static PerfUtil getPerfUtil(Object key)
	{
		PerfUtil res = (PerfUtil)registry.get(key);
		if(res == null)
		{
			res = new PerfUtil(key.toString(),false);
			registry.put(key,res);
		}
		return res;
	}
	public static PerfUtil removePerfUtil(Object key)
	{
		PerfUtil res = (PerfUtil)registry.get(key);
		if(res != null)
		{
			registry.remove(key);
		}
		return res;
	}
	/**
	 * @return Returns the debug.
	 */
	public boolean isDebug() {
		return debug;
	}
	/**
	 * @param debug The debug to set.
	 */
	public PerfUtil setDebug(boolean debug) {
		this.debug = debug;
		return this;
	}
}