/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: HierarchyXMIQueryEngine.java,v 1.2 2007/12/01 00:06:25 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService;
/**
 * This is internal code and it is not supposed to be used directly.
 * 
 * @author Marius Slavescu (slavescu@ca.ibm.com)
 * @since 3.3
 *  
 */
public class HierarchyXMIQueryEngine implements IExtendedQueryService {
	protected Map savedQueries = new HashMap();
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#executeQuery(org.eclipse.hyades.models.hierarchy.extensions.Query, org.eclipse.emf.ecore.resource.ResourceSet, java.util.Collection)
	 */
	public QueryResult executeQuery(Query query, ResourceSet targetResourceSet, Collection notLoadedTypes) {
		if (query instanceof SimpleSearchQuery) {
			SimpleSearchQueryEngine engine = new SimpleSearchQueryEngine((SimpleSearchQuery) query, targetResourceSet);
			return engine.execute();
		}
		return null;
	}
	/**
	 * Not implemented in this case the client should manage the query
	 * 
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#executeQuery(java.lang.String, org.eclipse.emf.ecore.resource.ResourceSet, java.util.Collection)
	 */
	public QueryResult executeQuery(String queryName, ResourceSet targetResourceSet, Collection notLoadedTypes) {
		// TODO Auto-generated method stub
		return null;
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#validateQuery(org.eclipse.hyades.models.hierarchy.extensions.Query)
	 */
	public boolean validateQuery(Query query) {
		// TODO Auto-generated method stub
		return false;
	}
	/**
	 * Not implemented in this case the client should manage the query
	 * 
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#storeQuery(org.eclipse.hyades.models.hierarchy.extensions.Query)
	 */
	public boolean storeQuery(Query query) {
		return false;
	}
	public Object executeQuery(String queryString, String targetResourceURI, int mode, Properties p) {
		// TODO Auto-generated method stub
		return null;
	}
}