/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: HierarchyXMIResourceExtension.java,v 1.1 2007/11/27 04:28:40 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
/**
 * This is internal code and is not supposed to be used directly.
 * @author Marius Slavescu - slavescu@ca.ibm.com
 * @since 3.3
 *  
 */
public class HierarchyXMIResourceExtension implements IHyadesResourceExtension {
	List list;
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension#getStoreType(java.lang.String)
	 */
	public String getStoreType(String postfix) {
		return "XMI";
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension#getSupportedPostfixes()
	 */
	public List getSupportedPostfixes() {
		if (list == null) {
			list = new ArrayList();
			list.add("__XMI.trcaxmi");
			list.add(".trcaxmi");
			list.add(".execution");
		}
		return list;
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension#createResource(org.eclipse.emf.common.util.URI,
	 *      java.util.Properties)
	 */
	public IHyadesExtendedResource createResource(URI uri, Properties properties) {
		// all resources retured by HierarchyResourceSetImpl should be
		// IHyadesExtendedResource
		return (IHyadesExtendedResource) HierarchyResourceSetImpl.getInstance().createResource(uri);
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension#createResource(org.eclipse.emf.common.util.URI,
	 *      java.util.Properties, java.util.Collection)
	 */
	public IHyadesExtendedResource createResource(URI uri, Properties properties, Collection notLoaded) {
		return createResource(uri, properties);
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension#createTables(java.lang.String,
	 *      java.util.Properties)
	 */
	public boolean createTables(String storeType, Properties properties) {
		// do nothing, it's not a DB backed extension
		return false;
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension#dropTables(java.lang.String,
	 *      java.util.Properties)
	 */
	public boolean dropTables(String storeType, Properties properties) {
		// do nothing, it's not a DB backed extension
		return false;
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#executeQuery(org.eclipse.hyades.models.hierarchy.extensions.Query,
	 *      org.eclipse.emf.ecore.resource.ResourceSet, java.util.Collection)
	 */
	public QueryResult executeQuery(Query query, ResourceSet targetResourceSet, Collection notLoadedTypes) {
		return new HierarchyXMIQueryEngine().executeQuery(query, targetResourceSet, notLoadedTypes);
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#executeQuery(java.lang.String,
	 *      org.eclipse.emf.ecore.resource.ResourceSet, java.util.Collection)
	 */
	public QueryResult executeQuery(String queryName, ResourceSet targetResourceSet, Collection notLoadedTypes) {
		return new HierarchyXMIQueryEngine().executeQuery(queryName, targetResourceSet, notLoadedTypes);
	}
	/**
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#validateQuery(org.eclipse.hyades.models.hierarchy.extensions.Query)
	 */
	public boolean validateQuery(Query query) {
		return new HierarchyXMIQueryEngine().validateQuery(query);
	}
	/**
	 * Not implemented in this case, the client is supposed to manage the query
	 * 
	 * @see org.eclipse.hyades.models.hierarchy.util.IExtendedQueryService#storeQuery(org.eclipse.hyades.models.hierarchy.extensions.Query)
	 */
	public boolean storeQuery(Query query) {
		// do nothing, the client is supposed to manage the query in this case
		return false;
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#createPagingList(org.eclipse.emf.ecore.EObject,
	 *      org.eclipse.emf.ecore.EStructuralFeature)
	 */
	public EList createPagingList(EObject owner, EStructuralFeature eStructuralFeature) {
		// do nothing
		return null;
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#createPagingList(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int)
	 */
	public EList createPagingList(Class dataClass, EObject owner, int featureID) {
		// do nothing
		return null;
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#createPagingList(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int, int)
	 */
	public EList createPagingList(Class dataClass, EObject owner, int featureID, int inverseFeatureID) {
		// do nothing
		return null;
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#setPagingSize(int)
	 */
	public void setPagingSize(int size) {
		// do nothing
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingListFactory#getPagingSize()
	 */
	public int getPagingSize() {
		// do nothing
		return 0;
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingMapFactory#createPagingMap(org.eclipse.emf.ecore.EObject,
	 *      org.eclipse.emf.ecore.EStructuralFeature)
	 */
	public EMap createPagingMap(EObject owner, EStructuralFeature eStructuralFeature) {
		// do nothing
		return null;
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingMapFactory#createPagingMap(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int)
	 */
	public EMap createPagingMap(Class dataClass, EObject owner, int featureID) {
		// do nothing
		return null;
	}
	/**
	 * Not implemented in this case
	 * 
	 * @see org.eclipse.hyades.loaders.util.IPagingMapFactory#createPagingMap(java.lang.Class,
	 *      org.eclipse.emf.ecore.EObject, int, int)
	 */
	public EMap createPagingMap(Class dataClass, EObject owner, int featureID, int inverseFeatureID) {
		// do nothing
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension#getStoreTypeNames(java.io.File)
	 */
	public List getStoreTypeNames(File file) {
		// TODO Auto-generated method stub
		return Collections.EMPTY_LIST;
	}
	public Object executeQuery(String queryString, String targetResourceURI, int mode, Properties p) {
		// TODO Auto-generated method stub
		return null;
	}
}