/**********************************************************************
 * Copyright (c) 2003, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: IntListImpl.java,v 1.1 2007/11/27 04:28:39 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;

import org.eclipse.hyades.models.hierarchy.util.IntList;

/**
 * 
 * @author slavescu
 *
 */
public class IntListImpl implements IntList {
	protected int[] data;
	protected int size;

	public IntListImpl() {
		data = new int[10];
		size = 0;
	}

	public IntListImpl(int initialCapacity) {
		data = new int[initialCapacity];
		size = 0;
	}

	public IntList compact() {
		int[] newData = new int[size];
		System.arraycopy(data, 0, newData, 0, size);
		data= newData;
		return this;
	}

	public int set(int value,int index) {
		if (index < 0 || index >= size)
			throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
		int oldValue = data[index];
		data[index]=value;
		return oldValue;
	}

	public int size() {
		return size;
	}

	public IntList add(int value) {
		ensureCapacity(size + 1);
		data[size++] = value;
		return this;
	}

	public IntList add(int value, int index) {
		if (index < 0 || index > size)
			throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
		ensureCapacity(size + 1);
		System.arraycopy(data, index, data, index + 1, size - index);
		data[index] = value;
		size++;
		return this;
	}

	protected void ensureCapacity(int index) {
		if (index >= data.length) {
			int oldCapacity = data.length;
			if (index > oldCapacity) {
				int newCapacity = (oldCapacity * 3) / 2 + 1;
				if (newCapacity < index)
					newCapacity = index;
				
				int[] newData = new int[newCapacity];
				System.arraycopy(data, 0, newData, 0, size);
				data= newData;
			}
		}
	}

	public int get(int index) {
		if (index < 0 || index >= size)
			throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
		return data[index];
	}


	public int indexOf(int value, int startIndex) {
		if (startIndex < 0)
			throw new IndexOutOfBoundsException("Index: " + startIndex + ", Size: " + size);
		for (int i = startIndex; i < size; i++) {
			if(data[i]==value)
				return i;
		}
		return -1;
	}

	public int lastIndexOf(int value, int endIndex) {
		if (endIndex < 0)
			throw new IndexOutOfBoundsException("Index: " + endIndex + ", Size: " + size);		
		for (int i = endIndex; i-->0;) {
			if(data[i]==value)
				return i;
		}
		return -1;
	}

	public int[] getValues() {
		return data;
	}

	public IntList clear() {
		data=new int[0];
		size = 0;
		return this;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("[");
		for (int i = 0; i < size; i++) {
			if(i>0)
                buf.append(", ");
            buf.append(data[i]);
		}

		buf.append("]");
		return buf.toString();
	}
	
	public int[] toArray() {
		if(data==null && data.length==0)
			return new int[0];
		int[] res = new int[size];
		System.arraycopy(data,0,res,0,size);
		return res;
	}
}
