/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: PrimeGenerator.java,v 1.3 2008/01/24 02:28:17 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;

/**
 * 
 * @author slavescu
 *
 */
public class PrimeGenerator {

	public static void main(String[] args) {
		int[] pArray = new int[10000000]; //primes to check against
		int num = 0; //num = number of primes saved
		pArray[0] = 3; //store initial prime
		int test = 5; //first number to test is 5
		int lenght = pArray.length - 1;
		num = genPrimes(pArray, num, test, lenght);

		System.out.println("nr primes=" + num + ", largest number=" + pArray[num]);
//		System.out.println("primes=");
//		for (int i = 0; i <= num; i++) {
//			System.out.println(pArray[i]);
//		}
		sizes(pArray, num, 1.13f);
		sizes(pArray, num, 1.33f);
		sizes(pArray, num, 1.5f);
		sizes(pArray, num, 1.75f);
	}

	public static int genPrimes(int[] pArray, int num, int test, int lenght) {
		int index;
		loop1: while (num < (pArray.length - 1)) {
			index = 0;
			while (index <= num && test >= (pArray[index] * pArray[index])) {
				if (test % pArray[index] == 0)
				{
					test += 2;
					continue loop1;
				} else
					index++;
			}
			if (num < lenght) {
				pArray[++num] = test; //save prime
			} 

			test += 2;
		}
		return num;
	}

	protected static void sizes(int[] pArray, int num, float growth) {
		int size = 89;
		int pos = 0;
		int[] sizes = new int[1000];
		int sizeNr = 0;
		while (size < pArray[num]) {
			size = (int) (size * growth);

			for (int i = pos; i <= num; i++) {
				if (pArray[i] > size) {
					pos = i;
					sizes[sizeNr++] = pArray[i];
					break;
				}
			}
		}

		System.out.println("nr sizes=" + sizeNr + ", growth=" + growth + ", largest size=" + sizes[sizeNr - 1]);

		System.out.println("sizes=");
		for (int i = 0; i < sizeNr; i++) {
			System.out.println(sizes[i]);
		}
	}
}
