/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: 
 **********************************************************************/

package org.eclipse.hyades.models.hierarchy.util.internal;

import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunction;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

public class SSQEDebug {

	private static String r(int len) {
		len *= 3;
		String r = "";
		for(int x = 0; x < len; x++) {
			r += " ";
		}
		return r;
	}
	
	public static String outputOrderByElement(OrderByElement e, int depth) {
		String s = "";
		s += r(depth)+"operand: "+e.getOperand();
		s += r(depth)+"operator: " +	e.getOperator();
		return s;
		
	}
	
	public static String outputNumericFunction(NumericFunction e, int depth) {
		String s = "";
		
		s += r(depth) + "Function:"+e.getFunction() + "\n";

		for(Operand o : e.getArguments()) {
			s += outputOperand(o, depth+1);
		}

		return s;
	}
	
	public static String outputSimpleOperand(SimpleOperand e, int depth) {
		String s = "";
		
		if(e.getRawValue() != null)
			s += r(depth) + "Raw Value: "+e.getRawValue()+"\n";
		
		if(e.getValue() != null)
			s += r(depth) + "Value: "+e.getValue()+"\n";
		
		if(e.getType() != null)
			s += r(depth) + "Type: "+e.getType()+"\n";
		
		if(e.getFeature() != null)
			s += r(depth) + "Feature: "+e.getFeature()+"\n";
		
		if(e.getValueType() != null)
			s += r(depth) + "Value Type: "+e.getValueType()+"\n";
				
		return s;
	}
	
	public static String outputOperand(Operand o, int depth) {
		String s = "";
		
		s += r(depth) + "(operand class - "+o.getClass()+") { \n";
		
		if(o instanceof ArithmeticExpression) {
			s += outputArithmeticExpression((ArithmeticExpression)o, depth+1);
		} else if(o instanceof NumericFunction) {
			s += outputNumericFunction((NumericFunction)o, depth+1);
		} else if(o instanceof SimpleOperand) {
			s += outputSimpleOperand((SimpleOperand)o, depth+1);
		} else {
			s += "Unrecognized operand: " + o.getClass() +"\n";
		}
		
		s += r(depth) + "}\n";
		
		return s;
	}
	
	public static String outputLogicalExpression(LogicalExpression e, int depth) {
		String s = "";
		
		s += r(depth) + "operator: " + e.getOperator() + "\n";
		s += r(depth) + "arguments: \n";
		for(WhereExpression we : e.getArguments()) {
			s+= outputWhereExpression(we, depth+1);
		}
		
		return s;
	}
	
	public static String outputBinaryExpression(BinaryExpression e, int depth) {
		String s = "";
		s += r(depth) + "operator: "+e.getOperator() + "\n";
		s += r(depth) + "left Operand: \n";
		s += outputOperand(e.getLeftOperand(), depth+1);
		s += r(depth) + "right Operands: \n";
		for(Operand o : e.getRightOperands()) {
			s += outputOperand(o, depth+1);
		}
		return s;
	}
	
	public static String outputWhereExpression(WhereExpression e, int depth) {
		String s = "";
		
		s += r(depth) + "(where expression class: "+e.getClass()+") {\n";
		if(e instanceof BinaryExpression) {
			s += outputBinaryExpression((BinaryExpression)e, depth+1);
		} else if(e instanceof LogicalExpression) {
			s += outputLogicalExpression((LogicalExpression)e, depth+1);
		} else {
			s += r(depth)+"Unrecognized WhereExpression: " + e.getClass() +"\n";
		}
		
		s += r(depth) + "}\n";
		
		return s;
		
	}
	
	
	public static String outputArithmeticExpression(ArithmeticExpression e, int depth) {
		String s = "";
		s += r(depth) + "operator:" + e.getOperator() + "\n";
		for(Operand o : e.getArguments()) {
			s += outputOperand(o, depth+1);
		}
		return s;
	}
	
	public static void outputQuery(SimpleSearchQuery query, int depth) {
		
		String s = "";
		
		s += r(depth)+"Query name: "+query.getName() + "\n";
		s += r(depth)+"Order by expressions:\n";
		for(OrderByElement e : query.getOrderByExpresions()) {
			s += outputOrderByElement(e, depth+1);
		}
		
		s += r(depth)+"Output elements:\n";
		for(Operand e : query.getOutputElements()) {
			s+= outputOperand(e, depth+1);
		}
		
		s+= r(depth)+"Where expression:\n";
		s += outputWhereExpression(query.getWhereExpression(), depth+1);
		
		s+= r(depth)+ "SubQueries:\n";
		for(Query q : query.getSubQuery()) {
			s += r(depth)+ q.getClass();
		}
		
		System.out.println("------------------");
		System.out.println(s);
		
		
//		query.getOrderByExpresions()
		
	}
	

}
