/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SimpleFragmentHandler.java,v 1.3 2008/01/24 02:28:17 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util.internal;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import javax.xml.parsers.SAXParser;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
/**
 * Implementation not complete yet!
 * @author Marius Slavescu (slavescu@ca.ibm.com)
 * @since 4.0
 */
public class SimpleFragmentHandler implements XMLFragmentHandler {
	protected static final int FORWARD_BUFFER_MAX_SIZE = 64 * 1024;
	protected IXMLLoader handler;
	protected int endOffset;
	protected long currentElementNameStart;
	protected long currentElementNameEnd;
	protected long currentAttributeNameStart;
	protected long currentAttributeNameEnd;
	protected long currentAttributeValueStart;
	protected long currentAttributeValueEnd;
	protected byte previousByte;
	protected List elementsStack;
	protected boolean inElementStartTag;
	protected boolean inElementContent;
	protected boolean inElementEndTag;
	protected byte[] currentBuffer;
	protected boolean inAttributeSection;
	protected boolean inIgnoredContent;
	protected long currentElementContentEnd;
	protected long currentElementContentStart;
	protected long globalStartOffset;
	protected long globalIndex;
	protected byte[] forwardBuffer;
	protected String scannerId;
	
	
	protected int fragmentCount = 0;

	protected int forwardBufferPosition;
	// protected int depth;
	public void scanContent(byte[] newFragment, int offset, int length) throws InvalidXMLException {
		currentBuffer = newFragment;
		endOffset = offset + length;
		for (int j = offset; j < endOffset; j++) {
			globalIndex=globalStartOffset+j;
			switch (currentBuffer[j]) {
				case ' ' :
				case '\t' :
					if (currentElementNameStart != -1) {
						currentElementNameEnd = globalIndex - 1;
						startElement();
						inAttributeSection = true;
						currentElementNameStart = -1;
					} else if (currentAttributeNameStart != -1) {
						currentAttributeNameEnd = globalIndex - 1;
						attributeName();
						currentAttributeNameStart = -1;
					}
					break;
				case '\n' :
				case '\r' :
					// do something
					break;
				case '<' :
					if (inElementContent) {
						currentElementContentEnd = globalIndex - 1;
						if (currentAttributeNameEnd > currentAttributeNameStart)
							characters();
						currentElementContentStart = -1;
						inElementContent = false;
					} else if (!inIgnoredContent) {
						// assume start tag
						inElementStartTag = true;
					}
					previousByte = currentBuffer[j];
					break;
				case '/' :
					if (inElementStartTag) {
						previousByte = currentBuffer[j];
					} else if (!inIgnoredContent && previousByte == '<') {
						inElementEndTag = true;
					}
					break;
				case '>' :
					if (inElementStartTag) {
						if (previousByte == '/') {
							endElement(globalIndex);
						} else if (currentElementNameStart != -1) {
							currentElementNameEnd = globalIndex - 1;
							startElement();
							currentElementNameStart = -1;
							inElementContent = true;
							currentElementContentStart = globalIndex + 1;
						}
						inElementStartTag = false;
						inAttributeSection = false;
					} else if (inElementEndTag) {
						endElement(globalIndex);
						inElementEndTag = false;
					} else if (inIgnoredContent) {
						if (previousByte == '-' || previousByte == ']' || previousByte == '?') {
							inIgnoredContent = false;
						}
					}
					previousByte = currentBuffer[j];
					break;
				case '!' :
					if (!inIgnoredContent) {
						if (previousByte == '<') {
							inIgnoredContent = true;
							inElementStartTag = false;
						}
					}
					previousByte = currentBuffer[j];
					break;
				case '-' :
					if (!inIgnoredContent) {
						if (previousByte == '<') {
							inIgnoredContent = true;
							inElementStartTag = false;
						}
					}
					previousByte = currentBuffer[j];
					break;
				case '?' :
					if (!inIgnoredContent) {
						if (previousByte == '<') {
							inIgnoredContent = true;
							inElementStartTag = false;
						}
					}
					previousByte = currentBuffer[j];
					break;
				case '=' :
					if (inAttributeSection) {
						if (currentAttributeNameStart != -1) {
							currentAttributeNameEnd = globalIndex - 1;
							attributeName();
							currentAttributeNameStart = -1;
							previousByte = currentBuffer[j];
						}
					}
					break;
				case '"' :
					if (currentAttributeValueStart != -1) {
						currentAttributeValueEnd = globalIndex - 1;
						attributeValue();
						currentAttributeValueStart = -1;
					} else if (inAttributeSection) {
						currentAttributeValueStart = globalIndex + 1;
					}
					previousByte = currentBuffer[j];
					break;
				default :
					if (inElementStartTag) {
						if (inAttributeSection) {
							if (currentAttributeValueStart == -1 && currentAttributeNameStart == -1)
								currentAttributeNameStart = globalIndex;
						} else if (currentElementNameStart == -1) {
							currentElementNameStart = globalIndex;
						}
					}
					previousByte = currentBuffer[j];
					break;
			}
		}
		if (currentAttributeNameStart != -1) {
			addBuffer(currentAttributeNameStart);
		} else if (currentAttributeValueStart != -1) {
			addBuffer(currentAttributeValueStart);
		} else if (currentElementNameStart != -1) {
			addBuffer(currentElementNameStart);
		} else if (currentElementContentStart != -1) {
			currentElementContentEnd = globalIndex;
			if (currentAttributeNameEnd > currentAttributeNameStart)
				characters();
			currentElementContentStart = globalIndex + 1;
		}
		globalStartOffset += length;
	}
	protected void addBuffer(long globalOffset) {
		int l = endOffset - (int)(globalOffset - globalStartOffset);
		if((forwardBufferPosition+l)>forwardBuffer.length)
			growForwardBuffer(forwardBufferPosition+l);
		System.arraycopy(currentBuffer, (int)(globalOffset - globalStartOffset),forwardBuffer,forwardBufferPosition,l);
		forwardBufferPosition=forwardBufferPosition+l;
	}
	protected void growForwardBuffer(int newSize) {
		byte[] b = new byte[newSize];
		synchronized (forwardBuffer) {
			System.arraycopy(forwardBuffer, 0,b,0,forwardBufferPosition);
			forwardBuffer = b;
		}
	}
	protected void characters() {
		char[] val = makeCharArray(currentElementContentStart, (int)(currentElementContentEnd - currentElementContentStart + 1));
		handler.characters(val, 0, val.length);
	}
	protected void attributeValue() {
		handler.attributeValueCharacters(makeString(currentAttributeValueStart, (int)(currentAttributeValueEnd - currentAttributeValueStart + 1)));
	}
	protected char[] makeCharArray(long globalOffset, int length) {
		return makeString(globalOffset, length).toCharArray();
	}
	protected String makeString(long globalOffset, int length) {
		String res = null;
		if (globalStartOffset <= globalOffset) {
			int localOffset = (int)(globalOffset - globalStartOffset);
			res = LoadersUtils.makeString(currentBuffer, localOffset, length);
		} else {
			//			int lastPos = forwardBufferStartOffset + forwardBuffer.position();
			System.arraycopy(currentBuffer, 0, forwardBuffer, forwardBufferPosition, length - forwardBufferPosition);
			res = LoadersUtils.makeString(forwardBuffer, 0, length);
			//reset forwardBuffer
			forwardBufferPosition=0;
		}
		return res;
	}
	protected void attributeName() {
		handler.attributeName(makeString(currentAttributeNameStart, (int)(currentAttributeNameEnd - currentAttributeNameStart + 1)));
	}
	protected void startElement() {
		elementsStack.add(makeString(currentElementNameStart, (int)(currentElementNameEnd - currentElementNameStart + 1)));
		handler.startElement((String) elementsStack.get(elementsStack.size() - 1), true, false);
	}
	protected void endElement(long i) {
		handler.endElement((String) elementsStack.get(elementsStack.size() - 1), (int)(i + 1));
		elementsStack.remove(elementsStack.size() - 1);
	}
	public void terminateParser() {
		elementsStack = null;
		forwardBuffer = null;
		reset();
	}
	public void setXMLLoader(IXMLLoader handler) {
		this.handler = handler;
		reset();
		elementsStack = new ArrayList();
		forwardBuffer = new byte[FORWARD_BUFFER_MAX_SIZE*2];// this should be enough for most cases
		// called here to avoid extra checking
		handler.startDocument();
	}
	protected void reset() {
		inIgnoredContent = false;
		inElementContent = false;
		inElementEndTag = false;
		currentAttributeNameEnd = -1;
		currentAttributeNameStart = -1;
		currentAttributeValueEnd = -1;
		currentAttributeValueStart = -1;
		currentElementNameEnd = -1;
		currentElementNameStart = -1;
		currentElementContentEnd = -1;
		currentElementContentStart = -1;
		globalStartOffset = 0;
		globalIndex = 0;
		endOffset = -1;
		previousByte = 0;
	}
	public static void main(String[] args) {
		new SimpleFragmentHandler().testScanners();
	}
	protected void testScanners() {
		IXMLLoader x = createDebugXMLLoader();
//		XMLFragmentHandler s = null;
//		String inputFileName = "d:\\test\\input\\traces\\hyades-3-20040316-1_repaired.trcxml"; //50mb
//		String inputFileName = "e:\\test\\input\\traces\\hyades-3-20040316-1.trcxml";//600mb
//		String inputFileName = "d:\\test\\input\\statistical\\incommingData-1118277766734.xml ";
//		String inputFileName = "d:\\download\\incommingData-1118277766734.xml ";
//		String inputFileName = "E:\\test\\input\\traces\\defects\\73409-test-2-negative-values-invalid-overhead.xml";
		String inputFileName = "E:\\test\\input\\traces\\defects\\trace27mb.xml";
//		testSimpleFragmentHandler(x, inputFileName);
		testSAXFragmentHandler(x, inputFileName);
	}
//	private void testSimpleFragmentHandler(IXMLLoader x, String inputFileName) {
//		XMLFragmentHandler s;
//		scannerId = "optimizedScanner";
//		s = new SimpleFragmentHandler();
//		parserTest(s, x, inputFileName);
//	}
	protected void testSAXFragmentHandler(IXMLLoader x, String inputFileName) {
		XMLFragmentHandler s;
		scannerId = "SAXScanner";
		fragmentCount=0;
//		s = new SAXFragmentHandler();
		s = new CrimsonFragmentHandler();
//		s = new RealTimeFragmentHandler();
		parserTest(s, x, inputFileName);
		
		PerfUtil p=null;
		try {
			fragmentCount=0;
			// test raw parser
			SAXParser parser = XMLLoader.makeParser();
			p = PerfUtil.createInstance( parser+ " test", true);
			parser.parse(new InputSource(new FileInputStream(inputFileName)),new DefaultHandler(){
				protected boolean hasContent = false;
				protected boolean debug;// = ModelDebugger.INSTANCE.debug;
				protected int depth = 0;

				public void characters(char[] ch, int start, int length) {
					if (debug) {
						if (!hasContent) {
							ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '>');
							ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '\n');
						}
						String s = new String(ch, start, length);
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, s.getBytes());
						hasContent = true;
					}
				}
				public void endElement(String uri, String localName, String qName) throws SAXException {
					depth--;
					if (debug) {
						if (hasContent) {
							ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '<');
							ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '/');
							ModelDebugger.INSTANCE.writeBinaryLog(scannerId, qName.getBytes());
							hasContent = false;
						} else
							ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '/');
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '>');
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '\n');
					}
				}
				public void startDocument() {
				}
				public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
					if (depth == 1)
						fragmentCount++;
					depth++;
					if (debug) {
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '<');
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, qName.getBytes());
						hasContent = false;
					}
				}
			});

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		p.stopAndPrintStatus("ProcessedFragments=" + fragmentCount);
	}
	public IXMLLoader createDebugXMLLoader() {
		IXMLLoader x = new IXMLLoader() {
			protected boolean hasContent = false;
			protected boolean debug;// = ModelDebugger.INSTANCE.debug;
			protected int depth = 0;
			public void setCollectionMode(int collectionMode) {
				// TODO Auto-generated method stub
			}
			public HierarchyContext getContext() {
				// TODO Auto-generated method stub
				return null;
			}
			public int getProcessedFragments() {
				return fragmentCount;
			}
			public void attributeName(String name) {
				if (debug) {
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) ' ');
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, name.getBytes());
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '=');
				}
			}
			public void attributeValueCharacters(String attributeValue) {
				if (debug) {
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '"');
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, attributeValue.getBytes());
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '"');
				}
			}
			public void characters(char[] ch, int start, int length) {
				if (debug) {
					if (!hasContent) {
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '>');
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '\n');
					}
					String s = new String(ch, start, length);
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, s.getBytes());
					hasContent = true;
				}
			}
			public void cleanUp() {
				fragmentCount = 0;
				depth = 0;
				hasContent = false;
			}
			public void endDocument(Object object, int i) {
			}
			public void endElement(String elementName, int currentOffset) {
				depth--;
				if (debug) {
					if (hasContent) {
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '<');
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '/');
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, elementName.getBytes());
						hasContent = false;
					} else
						ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '/');
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '>');
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '\n');
				}
			}
			public void error(InvalidXMLException exception) {
				// TODO Auto-generated method stub
			}
			public void loadEvent(byte[] buffer, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException {
				// TODO Auto-generated method stub
			}
			public void loadEvent(byte[] buffer, int length, boolean loadToModel) throws InvalidXMLException {
				// TODO Auto-generated method stub
			}
			public void loadEvent(byte[] buffer, int length) throws InvalidXMLException {
				// TODO Auto-generated method stub
			}
			public void restartParser() {
				// TODO Auto-generated method stub
			}
			public void startDocument() {
			}
			public void startElement(String elementName, boolean hasAttributes, boolean isEmpty) {
				if (depth == 1)
					fragmentCount++;
				depth++;
				if (debug) {
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, (byte) '<');
					ModelDebugger.INSTANCE.writeBinaryLog(scannerId, elementName.getBytes());
					hasContent = false;
				}
			}
		};
		return x;
	}
	public void parserTest(XMLFragmentHandler s, IXMLLoader x, String inputFileName) {
		s.setXMLLoader(x);
		processTextFile(scannerId, x, s, inputFileName);
		x.cleanUp();
	}
	protected void processFile(String scannerId, IXMLLoader x, XMLFragmentHandler s, String inputFileName) {
		InputStream in = null;
		try {
			byte[] b = new byte[FORWARD_BUFFER_MAX_SIZE];
			int i;
			in = getInputStream(inputFileName);
			if (in == null)
				System.out.println("SimpleFragmentHandler.processFile() - null input stream");
			PerfUtil p = PerfUtil.createInstance(scannerId + " test", true);
//			BufferedInputStream bufferedInputStream = new BufferedInputStream(in);
			
			while ((i = in.read(b)) != -1) {
				s.scanContent(b, 0, i);
				Thread.sleep(2000);
			}
			ModelDebugger.INSTANCE.writeBinaryLog(scannerId, ("\nProcessedFragments=" + x.getProcessedFragments()).getBytes());
			ModelDebugger.INSTANCE.getBinaryLog(scannerId).close();
			p.stopAndPrintStatus("ProcessedFragments=" + x.getProcessedFragments());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	protected void processTextFile(String scannerId, IXMLLoader x, XMLFragmentHandler s, String inputFileName) {
		InputStream in = null;
		try {
			byte[] b = new byte[FORWARD_BUFFER_MAX_SIZE];
//			int i;
			in = getInputStream(inputFileName);
			if (in == null)
				System.out.println("SimpleFragmentHandler.processFile() - null input stream");
			PerfUtil p = PerfUtil.createInstance(scannerId + " test", true);
			BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
			String line;
			StringBuffer sb = new StringBuffer();
			int count=0;
			while ((line = bufferedReader.readLine()) != null) {
				sb.append(line);
				if(count==50)
				{
					b=sb.toString().getBytes();
					s.scanContent(b, 0, b.length);
//					Thread.sleep(6650);
					sb.setLength(0);
					count=0;
				}
				else
					count++;
//				s.scanContent(line.getBytes(),0,line.getBytes().length);
			}
			if(sb.length()>0)
			{
				b=sb.toString().getBytes();
				s.scanContent(b, 0, b.length);
				sb.setLength(0);
			}
//			ModelDebugger.INSTANCE.writeBinaryLog(scannerId, ("\nProcessedFragments=" + x.getProcessedFragments()).getBytes());
//			ModelDebugger.INSTANCE.getBinaryLog(scannerId).close();
			p.stopAndPrintStatus("ProcessedFragments=" + x.getProcessedFragments());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	protected static InputStream getInputStream(String inputFileName) throws IOException {
		InputStream in = null;
		if (ModelDebugger.isZipFile(inputFileName)) {
			ZipFile zf = new ZipFile(inputFileName);
			Enumeration entries = zf.entries();
			if (entries.hasMoreElements()) {
				ZipEntry zipEntry = (ZipEntry) entries.nextElement();
				in = zf.getInputStream(zipEntry);
				in = new BufferedInputStream(in, FORWARD_BUFFER_MAX_SIZE);
			}
		} else {
			in = new BufferedInputStream(new FileInputStream(inputFileName), FORWARD_BUFFER_MAX_SIZE);
		}
		return in;
	}
	public void scanContent(InputStream inputStream, long offset, long length) {
		// TODO Auto-generated method stub
		
	}
}
