/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ModelDebugger.java,v 1.3 2008/01/28 21:03:24 apnan Exp $
 **********************************************************************/
package org.eclipse.hyades.models.util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
/**
 * @author slavescu
 */
public class ModelDebugger {
	public boolean debug = false;
	public boolean debugEventFlow = false;
	public boolean debugEventValue = false;
	public boolean debugEventsToFile = false;
	public boolean debugPerfUtil = false;
	public boolean debugUseOptimizedScanner = false;
	public boolean debugCustomMaps = false;
	public boolean debugUseVirtualImpl = false;
	public boolean debugUseCBEtoMemoryOutputter = true;
	public int debugUseCBEtoCSVOutputter = 1;//0==off, 1==on for localDB, 2==on for both local and remote DB
	public boolean debugLoadCSVFiles= true;
	public boolean debugDeleteCSVFiles = true;
	public boolean useSerializedByteCodeCache = true;
	public String debugDatabaseResourcePostfix=null;
	public int exceptionDepth = 3; // 0==don't log exceptions, x==print top x lines of the call stack not including the log method line 
	public boolean useEmbeddedPageControls = false;
	public boolean useSWTVirtualSupport = true;
	
	protected String plugin_name;
	protected String value;
	public static ModelDebugger INSTANCE = new ModelDebugger("org.eclipse.tptp.platform.models.hierarchy");
	protected Map binaryLogs = new HashMap();

	protected static final PrintStream printStream = System.out;
	
	public ModelDebugger(String plugin_name) {
		this.plugin_name = plugin_name;
		init();
	}
	protected void init() {
		try {
			value = getPlatformDebugOption(plugin_name + "/debug");
			if (value != null) {
				debug = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debug")!=null)
				{
					debug = Boolean.valueOf(System.getProperty("ModelDebugger.debug")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/eventsFlow");
			if (value != null) {
				debugEventFlow = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugEventFlow")!=null)
				{
					debugEventFlow = Boolean.valueOf(System.getProperty("ModelDebugger.debugEventFlow")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/eventsValue");
			if (value != null) {
				debugEventValue = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugEventValue")!=null)
				{
					debugEventValue = Boolean.valueOf(System.getProperty("ModelDebugger.debugEventValue")).booleanValue();
				}
			
			value = getPlatformDebugOption(plugin_name + "/debug/eventsToFile");
			if (value != null) {
				debugEventsToFile = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugEventsToFile")!=null)
				{
					debugEventsToFile = Boolean.valueOf(System.getProperty("ModelDebugger.debugEventsToFile")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/useOptimizedScanner");
			if (value != null) {
				debugUseOptimizedScanner = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugUseOptimizedScanner")!=null)
				{
					debugUseOptimizedScanner = Boolean.valueOf(System.getProperty("ModelDebugger.debugUseOptimizedScanner")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/PerfUtil");
			if (value != null) {
				debugPerfUtil = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugPerfUtil")!=null)
				{
					debugPerfUtil = Boolean.valueOf(System.getProperty("ModelDebugger.debugPerfUtil")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/customMaps");
			if (value != null) {
				debugCustomMaps = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugCustomMaps")!=null)
				{
					debugCustomMaps = Boolean.valueOf(System.getProperty("ModelDebugger.debugCustomMaps")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/useVirtualImpl");
			if (value != null) {
				debugUseVirtualImpl = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugUseVirtualImpl")!=null)
				{
					debugUseVirtualImpl = Boolean.valueOf(System.getProperty("ModelDebugger.debugUseVirtualImpl")).booleanValue();
				}
			
			value = getPlatformDebugOption(plugin_name + "/debug/useCBEtoMemoryOutputter");
			if (value != null) {
				debugUseCBEtoMemoryOutputter = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugUseCBEtoMemoryOutputter")!=null)
				{
					debugUseCBEtoMemoryOutputter = Boolean.valueOf(System.getProperty("ModelDebugger.debugUseCBEtoMemoryOutputter")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/useCBEtoCSVOutputter");
			if (value != null) {
				debugUseCBEtoCSVOutputter = Integer.parseInt(value);
			}
			else
				if(System.getProperty("ModelDebugger.debugUseCBEtoCSVOutputter")!=null)
				{
					debugUseCBEtoCSVOutputter = Integer.parseInt(System.getProperty("ModelDebugger.debugUseCBEtoCSVOutputter"));
				}			
			value = getPlatformDebugOption(plugin_name + "/debug/loadCSVFiles");
			if (value != null) {
				debugLoadCSVFiles = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugLoadCSVFiles")!=null)
				{
					debugLoadCSVFiles = Boolean.valueOf(System.getProperty("ModelDebugger.debugLoadCSVFiles")).booleanValue();
				}			
			value = getPlatformDebugOption(plugin_name + "/debug/deleteCSVFiles");
			if (value != null) {
				debugDeleteCSVFiles = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.debugDeleteCSVFiles")!=null)
				{
					debugDeleteCSVFiles = Boolean.valueOf(System.getProperty("ModelDebugger.debugDeleteCSVFiles")).booleanValue();
				}
			
			value = getPlatformDebugOption(plugin_name + "/debug/useSerializedByteCodeCache");
			if (value != null) {
				useSerializedByteCodeCache = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.useSerializedByteCodeCache")!=null)
				{
					useSerializedByteCodeCache = Boolean.valueOf(System.getProperty("ModelDebugger.useSerializedByteCodeCache")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/databaseResourcePostfix");
			if (value != null) {
				debugDatabaseResourcePostfix = value;
			}
			else
				if(System.getProperty("ModelDebugger.debugDatabaseResourcePostfix")!=null)
				{
					debugDatabaseResourcePostfix = System.getProperty("ModelDebugger.debugDatabaseResourcePostfix");
				}
			value = getPlatformDebugOption(plugin_name + "/debug/exceptionDepth");
			if (value != null) {
				exceptionDepth = Integer.parseInt(value);
			}
			else
				if(System.getProperty("ModelDebugger.debugExceptionDepth")!=null)
				{
					exceptionDepth = Integer.parseInt(System.getProperty("ModelDebugger.debugExceptionDepth"));
				}			
			value = getPlatformDebugOption(plugin_name + "/debug/useEmbeddedPageControls");
			if (value != null) {
				useEmbeddedPageControls = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.useEmbeddedPageControls")!=null)
				{
					useEmbeddedPageControls = Boolean.valueOf(System.getProperty("ModelDebugger.useEmbeddedPageControls")).booleanValue();
				}
			value = getPlatformDebugOption(plugin_name + "/debug/useSWTVirtualSupport");
			if (value != null) {
				useSWTVirtualSupport = value.equalsIgnoreCase("true");
			}
			else
				if(System.getProperty("ModelDebugger.useSWTVirtualSupport")!=null)
				{
					useSWTVirtualSupport = Boolean.valueOf(System.getProperty("ModelDebugger.useSWTVirtualSupport")).booleanValue();
				}
			
		} catch (Throwable e) {
			// the platform is not available so it needs to be set directly
		}
	}
	public synchronized int writeBinaryLog(String id, byte[] buffer) {
		return writeBinaryLog(id, buffer, 0, buffer.length);
	}
	public synchronized int writeBinaryLog(String id, byte buffer) {
		FileOutputStream f = getBinaryLog(id);
		if (f != null) {
			try {
				f.write(buffer);
				f.flush();
				return 1;
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return 0;
	}
	public synchronized int writeBinaryLog(String id, byte[] buffer, int offset, int length) {
		int real_length = Math.min(length, buffer.length - offset);
		if (real_length > 0) {
			FileOutputStream f = getBinaryLog(id);
			if (f != null) {
				try {
					f.write(buffer, offset, real_length);
					f.flush();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return real_length;
	}
	public FileOutputStream getBinaryLog(String id) {
		FileOutputStream f = (FileOutputStream) binaryLogs.get(id);
		if (f == null) {
			try {
				f = new FileOutputStream("/" + id + "-" + (new Date()).getTime());
				binaryLogs.put(id, f);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}
		return f;
	}
	public static boolean isZipFile(InputStream readStream) throws IOException {
		byte[] magic = new byte[2];
		if (readStream.read(magic) > 1) {
			if ((magic[0] == 'P') && (magic[1] == 'K')) {
				return true;
			}
		}
		return false;
	}
	public static boolean isZipFile(String fileName) throws IOException {
		FileInputStream readStream = new FileInputStream(fileName);
		boolean ret = isZipFile(readStream);
		readStream.close();
		readStream = null;
		return ret;
	}
	
	public String getPlatformDebugOption(String option) {
		if(option==null)
			return null;
        try {
            Class platform = Class.forName("org.eclipse.core.runtime.Platform");
            Method getDebugOption = platform.getMethod("getDebugOption", new Class[]{String.class});
            String value = (String)getDebugOption.invoke(null, new String[]{option});

            return value;
        } catch (Exception e) {
            return null;
        }
	}
	/**
	 * @param e
	 */
	public static void log(Throwable e) {
		log(e,null);
	}
	public static void log(Throwable e, String msg) {
		printStream.print(Thread.currentThread() + " - ");
		if(msg!=null)
			printStream.println(msg);
		if (e != null) {
			logCallstackWithLimit(e,10000,printStream);
		}
		else
		{
			printStream.print("\tnull Throwable");
			if(ModelDebugger.INSTANCE.exceptionDepth>0)
				logCallstackWithLimit(new Throwable("LOG_CALL_STACK"),ModelDebugger.INSTANCE.exceptionDepth,printStream);
		}
	}
	public static void logCallstackWithLimit(Throwable e, final int limit, PrintStream out) {
		StringWriter  stringWriter = new StringWriter (){
			public String toString() {
				StringBuffer buf = getBuffer();
				String[] sa= getBuffer().toString().split("\\n");
				buf.setLength(0);
				int newLimit = limit, start=0;
				if(sa.length>0&& sa[0].indexOf("LOG_CALL_STACK")>0)
				{
					newLimit++;
					start++;
				}
				if(sa.length>1 && sa[1].indexOf(ModelDebugger.class.getName())>0)
				{
					newLimit++;
					start++;
				}
				if(sa.length>2 && sa[2].indexOf(ModelDebugger.class.getName())>0)
				{
					newLimit++;
					start++;
				}
				for (int i = start; i < sa.length && i<newLimit; i++) {
					if(sa[i].indexOf(".JDBCHelper.")>0)
					{
						newLimit++;
						continue;
					}
					buf.append(sa[i]);
				}
				return buf.toString();
			}
		};
		e.printStackTrace(new PrintWriter(stringWriter));
		out.println(stringWriter.toString());
	}
	public static void log(String s) {
		printStream.println(Thread.currentThread()+" - "+s);
		if(INSTANCE.exceptionDepth > 0 )
			logCallstackWithLimit(new Throwable("LOG_CALL_STACK"),ModelDebugger.INSTANCE.exceptionDepth,printStream);
	}
	public static void log(int exceptionDepth, String s) {
		printStream.println(Thread.currentThread()+" - "+s);
		if(exceptionDepth > 0 )
			logCallstackWithLimit(new Throwable("LOG_CALL_STACK"),exceptionDepth,printStream);
	}
}