/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceModelInteraction.java,v 1.1 2010/08/18 20:37:23 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.util.provisional;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;

/**
 * A utility class for the traceModelInteraction extension point created based on the CustomContentProvider utility class.
 * 
 * Bug 322951
 *
 */
public class TraceModelInteraction {

	/**
	 * The ID of the extension point.
	 */
	private final static String TRACE_MODEL_INTERACTION_EXT_ID = ModelsHierarchyPlugin.getPlugin().getSymbolicName()	+ ".traceModelInteraction"; //$NON-NLS-1$

	/**
	 * Provides access to the contributors for the traceModelInteraction extension point.
	 * @return The registered plug-ins that use the extension point.
	 */
	public static ITraceModelInteraction[] getContributors() {
		IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TRACE_MODEL_INTERACTION_EXT_ID);
		List<ITraceModelInteraction> providers = new ArrayList<ITraceModelInteraction>();
		try {
			if(elements != null) {
				for (int configElement = 0; configElement < elements.length; configElement++) {
					ITraceModelInteraction provider = (ITraceModelInteraction) elements[configElement].createExecutableExtension("class"); //$NON-NLS-1$
					if(provider != null)
						providers.add(provider);
				}
			}
		} catch (CoreException e) {
			ModelsHierarchyPlugin.getPlugin().getLog().log(new Status(Status.ERROR, ModelsHierarchyPlugin.getPlugin().getSymbolicName(), e.getMessage()));
		}
		
		// Output the provider list to an array in order to return the result.
		ITraceModelInteraction[] providerArray = new ITraceModelInteraction[providers.size()];
		for(int i = 0; i < providers.size(); i++)
			providerArray[i] = (ITraceModelInteraction)providers.get(i);
		return providerArray;
	}

}
