/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: IHandlerElement.java,v 1.1 2007/11/27 04:28:49 apnan Exp $
 **********************************************************************/
package org.eclipse.tptp.platform.extensions;

import java.util.List;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;

/**
 * 
 * @author slavescu
 * 
 */
public interface IHandlerElement {

	public static final String VALUE = "value";
	public static final String PARAMETER = "parameter";
	public static final String VERSION = "version";
	public static final String TYPE = "type";
	public static final String TARGET_EXTENSION = "targetExtension";
	public static final String TARGET_ID = "targetId";
	public static final String PARENT_ID = "parentId";
	public static final String OWNER = "owner";
	public static final String NAME = "name";
	public static final String MODIFIER = "modifier";
	public static final String FUNCTION = "function";
	public static final String APPLICATION = "application";
	public static final String ID = "id";
	public static final String PRIORITY = "priority";
	public static final String CLASS = "class";	
	public static final String REPLACE = "replace";
	public static final String DISABLED = "disabled";
	public static String HANDLER_EP_NS = "org.eclipse.tptp.platform.models.hierarchy.handler";

	public String getId();

	// public void setId(String id);

	public String getVersion();

	// public void setVersion(String version);
	/**
	 * return the handler owner name, in OSGi case it would be the bundle symbolic name
	 */
	public String getOwner();

	// public void setOwner(String ownerId);

	public String getName();

	// public void setName(String name);

	public String getApplication();

	// public void setApplication(String application);

	public String getFunction();

	public String getType();

	// public void setType(String type);

	public String getClassName();

	// public void setClassName(String className);

	public String getTargetExtension();

	// public void setTargetExtension(String targetExtension);

	public float getPriority();

	// public void setPriority(String priority);

	// public IHandlerElement getParentHandler();

	// public void setParentHandler(IHandlerElement parentHandler);

	public String getParentId();

	// public void setParentId(String parentId);

	public String getModifier();

	// public void setModifier(String modifier);

	// public IHandlerElement getTargetHandler();

	// public void setTargetHandler(String targetHandler);

	public String getTargetId();

	public boolean isValid();

	public HyadesConfigurationElement getConfigurationElement();

	/**
	 * 
	 * @return list of parameter names, the index of the names will match the
	 *         index of the values in parameterValues list
	 */
	public List getParametersNames();

	/**
	 * 
	 * @return list of parameter values, the index of the values will match the
	 *         index of the names in parameterNames list
	 */
	public List getParametersValues();

	String getUniqueID();
}