/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: HandlerElementImpl.java,v 1.2 2008/01/24 02:28:19 apnan Exp $
 **********************************************************************/
package org.eclipse.tptp.platform.extensions.impl;

import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.tptp.platform.extensions.IHandlerElement;

/**
 * 
 * @author slavescu
 *
 */
public class HandlerElementImpl implements IHandlerElement{
	protected String id;
	protected String version;
	protected String owner;
	protected String name;
	protected String application;
	protected String function;
	protected String type;
	protected String className;
	protected String targetExtension;
	protected float priority;
	protected IHandlerElement parentHandler;
	protected String parentId;
	protected String modifier;
	protected IHandlerElement targetHandler;
	protected String targetId;
	
	protected HyadesConfigurationElement configurationElement;
	protected List parameterNames;
	protected List parameterValues;
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#getId()
	 */
	public String getId() {
		return id;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#setId(java.lang.String)
	 */
	public void setId(String id) {
		this.id = id;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#getName()
	 */
	public String getName() {
		return name;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#getApplication()
	 */
	public String getApplication() {
		return application;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#setApplication(java.lang.String)
	 */
	public void setApplication(String application) {
		this.application = application;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#getType()
	 */
	public String getType() {
		return type;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#setType(java.lang.String)
	 */
	public void setType(String type) {
		this.type = type;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#getClassName()
	 */
	public String getClassName() {
		return className;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#setClassName(java.lang.String)
	 */
	public void setClassName(String className) {
		this.className = className;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#getTargetExtension()
	 */
	public String getTargetExtension() {
		return targetExtension;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#setTargetExtension(java.lang.String)
	 */
	public void setTargetExtension(String targetExtension) {
		this.targetExtension = targetExtension;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#getPriority()
	 */
	public float getPriority() {
		return priority;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.extensions.impl.IHandler#setPriority(java.lang.String)
	 */
	public void setPriority(float priority) {
		this.priority = priority;
	}
	public IHandlerElement getParentHandler() {
		return parentHandler;
	}
	public void setParentHandler(IHandlerElement parentHandler) {
		this.parentHandler = parentHandler;
	}
	public String getParentId() {
		return parentId;
	}
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}
	public String getModifier() {
		return modifier;
	}
	public void setModifier(String modifier) {
		this.modifier = modifier;
	}
	public IHandlerElement getTargetHandler() {
		return targetHandler;
	}
	public void setTargetHandler(IHandlerElement targetHandler) {
		this.targetHandler = targetHandler;
	}

	public String getTargetId() {
		return targetId;
	}
	public void setTargetId(String targetId) {
		this.targetId = targetId;
	}
	
	public String getOwner() {
		return owner;
	}
	public void setOwner(String owner) {
		this.owner = owner;
	}
	public String getVersion() {
		return version;
	}
	public void setVersion(String version) {
		this.version = version;
	}
	public boolean isValid() {
		return configurationElement.getElement() instanceof IConfigurationElement ? ((IConfigurationElement)configurationElement.getElement()).isValid() : true;
	}
	public void setConfigurationElement(HyadesConfigurationElement configurationElement) {
		this.configurationElement = configurationElement;
		
	}
	public HyadesConfigurationElement getConfigurationElement() {
		return configurationElement;
	}
	public List getParametersNames() {
		return parameterNames;
	}
	public List getParametersValues() {
		return parameterValues;
	}
	public String getFunction() {
		return function;
	}
	public void setFunction(String function) {
		this.function = function;
	}
	public String getUniqueID()
	{
		return getApplication()+"/"+getFunction()+"/"+getId();
	}
}
