/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: IApplicationManager.java,v 1.1 2007/11/27 04:28:49 apnan Exp $
 **********************************************************************/
package org.eclipse.tptp.platform.extensions;

import java.util.List;

import org.eclipse.tptp.platform.extensions.impl.TPTPApplicationManager;

/**
 * 
 * @author slavescu
 *
 */
public interface IApplicationManager {
	public static IApplicationManager INSTANCE = TPTPApplicationManager.createInstance();

	/**
	 * 
	 * @param applicationAndFunction has this form "application/function", where application and function are handler properties
	 */
	public IHandlerElement getDefaultHandlerElement(String applicationAndFunction);
	/**
	 * Creates the default handler which has applicationAndFunction
	 * @param handlerId
	 * @return
	 */
	public Object createDefaultHandlerInstance(String applicationAndFunction);
	public Object createHandlerInstance(IHandlerElement handlerElement);
	/**
	 * 
	 * @param templateQuery if null will return all handler elements
	 * @param defaultsOnly
	 */
	public List findHandlerElements(IHandlerElement templateQuery, boolean defaultsOnly);
	public void addListener(IApplicationManagerListener listener, int targetEventType);
	public void removeListener(IApplicationManagerListener listener, int targetEventType);
}
