/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IgnoredXMLFragmentLoader.java,v 1.4 2008/03/24 23:08:03 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import java.math.BigDecimal;

import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;


/**
 * @author slavescu
 */
public class IgnoredXMLFragmentLoader implements XMLFragmentLoader, BinaryFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected HierarchyContext context;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
    	// do nothing
    }

    /**
     * Inefficient, pilot version.
     * TODO These methods should invoke real setters w/o toString conversion. 
     */
	public void addAttribute(String name, byte value) {
		addAttribute(name, Byte.toString(value));
	}

	public void addAttribute(String name, short value) {
		addAttribute(name, Short.toString(value));
	}

	public void addAttribute(String name, int value) {
		addAttribute(name, Integer.toString(value));
	}

	public void addAttribute(String name, long value) {
		addAttribute(name, Long.toString(value));
	}

	public void addAttribute(String name, double value) {
		addAttribute(name, new BigDecimal(value).setScale(19, BigDecimal.ROUND_DOWN).toString());
	}

	public void addCharacters(char[] data, int offset, int length) {
    	// do nothing
    }

    public void addYourselfInContext() {
    	// do nothing
    }

    public void cleanUp() {
        context = null;
    }

    public void endChild(String name) {
    	// do nothing
    }

    public void initialize(HierarchyContext context, String elementName) {
        this.context = context;
    }

    public void startChild(String name) {
    	// do nothing
    }

}
