/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLagentCreateLoader.java,v 1.2 2008/01/24 02:28:18 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.eclipse.hyades.models.util.ModelDebugger;


public class XMLagentCreateLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected String agentId;
    protected String agentName;
//    private String agentParameters;
    protected String agentType;
//    private String processIdRef;
//    private String version;
    protected double time;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (name.equals("agentId")) {
            agentId = value;
//        } else if (name.equals("processIdRef")) {
//            processIdRef = value;
        } else if (name.equals("agentName")) {
            agentName = value;
        } else if (name.equals("agentType")) {
            agentType = value;
        } else if (name.equals("time")) {
            time = Double.parseDouble(value);
//        } else if (name.equals("agentParameters")) {
//            agentParameters = value;
//        } else if (name.equals("version")) {
//            version = value;
        }
    }

    public void addYourselfInContext() {
        /* This agent may be being added in context of itself, if this is the case, return */
        TRCAgent agent = context.getAgent();
        TRCAgentProxy agentProxy = context.getAgentProxy();

        if (agent != null) {
            String rId = agent.getRuntimeId();

            if ((agentId != null) && (rId != null) && rId.equals(agentId)) {
            	setSessionStartTime(time,agentProxy);
                return;
            }

            agent = null;
        }

        /* We need at least an agentName, id and a processIdRef to find the process and create the agent */
        if ((agentName == null) || (agentId == null)) {
            return;
        }

        LoadersUtils.setDefaultContext(context);

        /* If we don't have a process association, find it based upon our monitor */
        TRCProcessProxy process = context.getProcessProxy();
        TRCMonitor monitor = context.getMonitor();
        TRCNode node = context.getNode();

        if (agent == null) {
            agent = LoadersUtils.locateAgentFromProcess(process, agentName, agentId);
        }

        if (agent != null) {
            if (agentId != null) {
                agent.setRuntimeId(agentId);
                if (agentProxy != null) agentProxy.setRuntimeId(agentId);
            } else {
                agent.setRuntimeId("0");
                if (agentProxy != null) agentProxy.setRuntimeId("0");
            }

            agent.setCollectionMode(context.getCollectionMode());
			setSessionStartTime(time,agentProxy);

            if (agent.eResource() != null) {
				registerAgent(agent);
                if(context.getAgent()==null)
                {
                	context.setAgent(agent);
                	context.setContextURI(agent.eResource().getURI().toString());
					LookupServiceExtensions.getInstance().register(null, context);
                }
				if(context.getAgentProxy()==null)
				{
					agentProxy = agent.getAgentProxy();
					if(agentProxy!=null)
					{
						context.setAgentProxy(agentProxy);
						agentProxy.setCollectionMode(context.getCollectionMode());
					}
					
				}
                return;
            }
        }

        String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
        Resource agDoc = null;

        if (monitorFolder != null) {
            String aName = monitor.getName()+ "_" + node.getName().trim() + "_" + process.getPid() + "_" + process.getRuntimeId() + "_" + StringUtil.change(agentName.trim(), " ", "");

            String pFileName = monitorFolder + aName;
            String rName = ModelDebugger.INSTANCE.debugDatabaseResourcePostfix!=null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length()>0 ? pFileName + ModelDebugger.INSTANCE.debugDatabaseResourcePostfix :	pFileName + ".trcaxmi";

            URI uri = SaveUtil.createURI(rName+"#").trimFragment();
            agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            agDoc.setModified(true);

            HierarchyResourceSetImpl.getInstance().getResources().add(agDoc);
//            SaveUtil.addDocument(agDoc);
        }

		if (agent == null) {
			agent = HierarchyFactory.eINSTANCE.createTRCAgent();
			agent.setCollectionMode(context.getCollectionMode());
			agentProxy=null;
		}

		if(agent.getAgentProxy()!=null)
			agentProxy = agent.getAgentProxy();

		if(agentType==null)
			agentType="Logging";
		
		if (agentProxy == null) {
			agentProxy = HierarchyFactory.eINSTANCE.createTRCAgentProxy();
			agentProxy.setName(agentName);
			agentProxy.setStartTime(time);
			agentProxy.setType(agentType);
			agentProxy.setProcessProxy(process);
			agentProxy.setCollectionMode(context.getCollectionMode());
		}

        agent.setName(agentName);

		setSessionStartTime(time,agentProxy);

        if (agentType != null) {
            agent.setType(agentType);
            agentProxy.setType(agentType);
        }

        agent.setRuntimeId(agentId);
        agentProxy.setRuntimeId(agentId);

        agent.setAgentProxy(agentProxy);

        agentProxy.setProcessProxy(context.getProcessProxy());

        context.setAgent(agent);
        context.setAgentProxy(agentProxy);
        context.setContextURI(agDoc.getURI().toString());

        LookupServiceExtensions.getInstance().register(null, context);
		registerAgent(agent);

        if (agDoc != null) {
            agDoc.getContents().add(agent);
        }
    }

	protected void registerAgent(TRCAgent agent) {
		AgentsContext agentsContext = (AgentsContext )LookupServiceExtensions.getInstance().locate(null,AgentsContext.class,LoadersUtils.getLookUpKey(agent.getRuntimeId()));
		if(agentsContext==null)
		{
			agentsContext = new AgentsContext(agent.getRuntimeId());
			LookupServiceExtensions.getInstance().register(null, agentsContext);
		}
		agentsContext.registerAgent(agent);
	}

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        agentId = null;
        agentName = null;
        agentType = null;
//        processIdRef = null;
        time = 0;
//        version = null;
    }
    
	public void setSessionStartTime(double time, TRCAgentProxy agentProxy) {
		if(agentProxy == null)
			return;

		agentProxy.setStartTime(time);

		TRCAgent agent = (TRCAgent)agentProxy.eGet(HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(),false);

		if ((agent != null) && !agent.eIsProxy()) {
			agent.setStartTime(time);
		}

	}

}
