/**********************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLagentDestroyLoader.java,v 1.3 2008/01/24 02:28:18 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;


public class XMLagentDestroyLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected String agentIdRef;
    protected double time;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (name.equals("agentIdRef")) {
            agentIdRef = value;
        } else if (name.equals("time")) {
            time = Double.parseDouble(value);
        }
    }

    public void addYourselfInContext() {
    	if(agentIdRef!=null && time!=0)
    	{
			TRCAgent agent = LoadersUtils.locateAgent(agentIdRef,context.getAgent());
			if(agent!=null)
			{
				agent.setStopTime(time);
				agent.getAgentProxy().setStopTime(time);
			}
    	}
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        agentIdRef = null;
        time = 0;
    }
    
}

