/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: BinaryFragment.java,v 1.2 2008/03/24 23:13:18 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary;

import java.io.IOException;

public class BinaryFragment {

	public static final int HEADER_LENGTH = 6;

	Short id;
	
	int length;
	
	int bodyOffset;
	
	byte[] body;
	
	public BinaryFragment(byte[] header, int offset, BFReader reader) throws IOException {
		Offset headerMarker = new Offset(offset, offset + HEADER_LENGTH);
		this.id = new Short((short)reader.readUnsignedShort(header, headerMarker));
		this.length = (int)reader.readUnsignedInt(header, headerMarker);
	}

	public Short getId() {
		return id;
	}

	public int getLength() {
		return length;
	}

	public int getBodyOffset() {
		return bodyOffset;
	}

	public void setBodyOffset(int bodyOffset) {
		this.bodyOffset = bodyOffset;
	}

	public byte[] getBody() {
		return body;
	}

	public void setBody(byte[] body) {
		this.body = body;
	}
	
	public static boolean isEOF(byte[] header, int offset) {
		int headerOffset = offset + HEADER_LENGTH;

		if (headerOffset > header.length) {
			return true;
		}
		for (int i = offset; i < headerOffset; ++i) {
			if (header[i] != 0) {
				return false;
			}
		}
		return true;
	}
}
