/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: NumberReader.java,v 1.3 2008/05/19 14:49:55 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary;

public interface NumberReader {
	public short readShort(byte[] b, Offset offset);
	
	public int readUnsignedShort(byte[] b, Offset offset);

	public int readInt(byte[] b, Offset offset);
	
	public long readUnsignedInt(byte[] b, Offset offset);

	public long readLong(byte[] b, Offset offset);
	
	public Long[] readLongArray(byte[] b, int length, Offset offset);

	public void setCpuFrequency(long frequency);
	
	public double readTimestamp(byte[] b, Offset offset);
	
	// helper method to avoid redundant data translation
	// provides direct string value for timestamp
	public String readTimestampAsString(byte[] b, Offset offset);
}
