/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: Offset.java,v 1.2 2008/03/24 23:13:18 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.hyades.loaders.internal.binary;

public class Offset {
	private int offset;
	
	private final long length;
	
	public Offset(int offset, long length) {
		if (offset < 0 || (length > 0 && offset > length)) {
			throw new IllegalArgumentException("Offset should be between 0 and " + length);
		}
		this.offset = offset;
		this.length = length;
	}
	
	public Offset(int offset) {
		this(offset, 0);
	}

	public int increaseOffset(int delta) {
		int oldOffset = offset;
		int newOffset = offset + delta;
		if (length > 0 && newOffset > length) {
			return -1;
		}
		offset = newOffset;
		return oldOffset;
	}
	
	public int getOffset() {
		return offset;
	}
	
	public long getLength() {
		return length;
	}
}
